/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class LamiTimestampAspect
extends LamiGenericAspect {
    public LamiTimestampAspect(String timestampName, int colIndex) {
        super(timestampName, null, colIndex, true, true);
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiTimestamp ts;
        Long timestamp;
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiTimestamp && (timestamp = (ts = (LamiTimestamp)data).getValue()) != null) {
            return TmfTimestampFormat.getDefaulTimeFormat().format(((Number)timestamp).longValue());
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiTimestamp) {
            LamiTimestamp ts = (LamiTimestamp)data;
            return ts.getValue();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

