/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VariableType implements Enumerator
{
    STRING(0, "STRING", "STRING"),
    TEXT(1, "TEXT", "TEXT"),
    PASSWORD(2, "PASSWORD", "PASSWORD"),
    PATTERN(3, "PATTERN", "PATTERN"),
    URI(4, "URI", "URI"),
    FILE(5, "FILE", "FILE"),
    FOLDER(6, "FOLDER", "FOLDER"),
    RESOURCE(7, "RESOURCE", "RESOURCE"),
    CONTAINER(8, "CONTAINER", "CONTAINER"),
    PROJECT(9, "PROJECT", "PROJECT"),
    BOOLEAN(10, "BOOLEAN", "BOOLEAN"),
    INTEGER(11, "INTEGER", "INTEGER"),
    FLOAT(12, "FLOAT", "FLOAT"),
    JRE(13, "JRE", "JRE");

    public static final int STRING_VALUE = 0;
    public static final int TEXT_VALUE = 1;
    public static final int PASSWORD_VALUE = 2;
    public static final int PATTERN_VALUE = 3;
    public static final int URI_VALUE = 4;
    public static final int FILE_VALUE = 5;
    public static final int FOLDER_VALUE = 6;
    public static final int RESOURCE_VALUE = 7;
    public static final int CONTAINER_VALUE = 8;
    public static final int PROJECT_VALUE = 9;
    public static final int BOOLEAN_VALUE = 10;
    public static final int INTEGER_VALUE = 11;
    public static final int FLOAT_VALUE = 12;
    public static final int JRE_VALUE = 13;
    private static final VariableType[] VALUES_ARRAY;
    public static final List<VariableType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariableType[]{STRING, TEXT, PASSWORD, PATTERN, URI, FILE, FOLDER, RESOURCE, CONTAINER, PROJECT, BOOLEAN, INTEGER, FLOAT, JRE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariableType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return TEXT;
            }
            case 2: {
                return PASSWORD;
            }
            case 3: {
                return PATTERN;
            }
            case 4: {
                return URI;
            }
            case 5: {
                return FILE;
            }
            case 6: {
                return FOLDER;
            }
            case 7: {
                return RESOURCE;
            }
            case 8: {
                return CONTAINER;
            }
            case 9: {
                return PROJECT;
            }
            case 10: {
                return BOOLEAN;
            }
            case 11: {
                return INTEGER;
            }
            case 12: {
                return FLOAT;
            }
            case 13: {
                return JRE;
            }
        }
        return null;
    }

    private VariableType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

