/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import aQute.bnd.osgi.Analyzer;
import java.net.URL;
import java.util.Objects;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MavenArtifactInstructionsWizard
extends Wizard {
    private static final String BND_PAGE = Messages.MavenArtifactInstructionsWizard_0;
    private String instructions;
    private boolean usedefaults;

    public MavenArtifactInstructionsWizard(BNDInstructions bndInstructions) {
        this.instructions = bndInstructions.getInstructions();
        this.usedefaults = this.instructions == null || this.instructions.isBlank();
        this.setWindowTitle(Messages.MavenArtifactInstructionsWizard_1);
        WizardPage page = new WizardPage(Messages.MavenArtifactInstructionsWizard_2){

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(1, true));
                final Button buttonInherit = new Button(composite, 32);
                buttonInherit.setText(Messages.MavenArtifactInstructionsWizard_3);
                final Text textField = new Text(composite, 2626);
                textField.setFont(JFaceResources.getTextFont());
                GridData layoutData = new GridData(1808);
                textField.setLayoutData((Object)layoutData);
                layoutData.heightHint = 100;
                final Link link = new Link(composite, 0);
                link.setText(String.format(Messages.MavenArtifactInstructionsWizard_4, BND_PAGE));
                link.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Program.launch((String)e.text);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (MavenArtifactInstructionsWizard.this.usedefaults) {
                    textField.setText(BNDInstructions.getDefaultInstructions().getInstructions());
                } else {
                    textField.setText(MavenArtifactInstructionsWizard.this.instructions);
                }
                buttonInherit.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean selection;
                        (this).MavenArtifactInstructionsWizard.this.usedefaults = selection = buttonInherit.getSelection();
                        textField.setEnabled(!selection);
                        link.setEnabled(!selection);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                textField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        (this).MavenArtifactInstructionsWizard.this.instructions = textField.getText();
                    }
                });
                buttonInherit.setSelection(MavenArtifactInstructionsWizard.this.usedefaults);
                textField.setEnabled(!buttonInherit.getSelection());
                link.setEnabled(!buttonInherit.getSelection());
                this.setControl((Control)composite);
            }

            public void performHelp() {
                IWizardContainer container = this.getContainer();
                if (container instanceof TrayDialog) {
                    TrayDialog dialog = (TrayDialog)container;
                    DialogTray tray = dialog.getTray();
                    if (tray != null) {
                        dialog.closeTray();
                    } else {
                        dialog.openTray((DialogTray)new BrowserTray(BND_PAGE));
                    }
                }
            }
        };
        this.addPage((IWizardPage)page);
        page.setImageDescriptor(ImageDescriptor.createFromURL((URL)Analyzer.class.getResource("/img/bnd-64.png")));
        page.setTitle(page.getName());
        page.setDescription(Messages.MavenArtifactInstructionsWizard_6);
    }

    public boolean performFinish() {
        return true;
    }

    public static BNDInstructions openWizard(Shell shell, BNDInstructions instructions) {
        Objects.requireNonNull(instructions, "BNDInstructions can't be null");
        MavenArtifactInstructionsWizard wizard = new MavenArtifactInstructionsWizard(instructions);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(800, 600);
        if (dialog.open() == 0) {
            if (wizard.usedefaults) {
                return new BNDInstructions(instructions.getKey(), null);
            }
            return new BNDInstructions(instructions.getKey(), wizard.instructions);
        }
        return null;
    }

    private static final class BrowserTray
    extends DialogTray {
        private final String url;

        public BrowserTray(String url) {
            this.url = url;
        }

        protected Control createContents(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout());
            GridData layoutData = new GridData(4, 4, true, true);
            container.setLayoutData((Object)layoutData);
            Browser browser = new Browser(container, 0);
            browser.setUrl(this.url);
            GridData data = new GridData(4, 4, true, true);
            data.minimumWidth = 600;
            data.widthHint = 800;
            browser.setLayoutData((Object)data);
            return container;
        }
    }
}

