/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.WorkspaceSymbolQuickAccessElement;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class WorkspaceSymbolsQuickAccessProvider
implements IQuickAccessComputer,
IQuickAccessComputerExtension {
    private List<@NonNull LanguageServer> usedLanguageServers;

    public QuickAccessElement[] computeElements() {
        return new QuickAccessElement[0];
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return this.usedLanguageServers == null || !this.usedLanguageServers.equals(LanguageServiceAccessor.getActiveLanguageServers(serverCapabilities -> Boolean.TRUE.equals(serverCapabilities.getWorkspaceSymbolProvider())));
    }

    public QuickAccessElement[] computeElements(String query, IProgressMonitor monitor) {
        this.usedLanguageServers = LanguageServiceAccessor.getActiveLanguageServers(serverCapabilities -> Boolean.TRUE.equals(serverCapabilities.getWorkspaceSymbolProvider()));
        if (this.usedLanguageServers.isEmpty()) {
            return new QuickAccessElement[0];
        }
        WorkspaceSymbolParams params = new WorkspaceSymbolParams(query);
        List res = Collections.synchronizedList(new ArrayList());
        try {
            CompletableFuture.allOf((CompletableFuture[])this.usedLanguageServers.stream().map(ls -> ls.getWorkspaceService().symbol(params).thenAcceptAsync(symbols -> {
                if (symbols != null) {
                    res.addAll(symbols.stream().map(WorkspaceSymbolQuickAccessElement::new).collect(Collectors.toList()));
                }
            })).toArray(CompletableFuture[]::new)).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        return res.toArray(new QuickAccessElement[res.size()]);
    }
}

