/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBBrowserPage;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalAuditMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalAuditMappingStrategyWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategyWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;

public final class CDODBUtil {
    public static final int DEFAULT_STATEMENT_CACHE_CAPACITY = 200;
    public static final String EXT_POINT_MAPPING_STRATEGIES = "mappingStrategies";
    public static final String PROP_WITH_RANGES = "withRanges";
    public static final String PROP_COPY_ON_BRANCH = "copyOnBranch";
    public static final String PROP_ZEROBASED_INDEX = "forceZeroBasedIndex";

    private CDODBUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new DBBrowserPage.Factory());
    }

    public static IDBStore createStore(IMappingStrategy mappingStrategy, IDBAdapter dbAdapter, IDBConnectionProvider dbConnectionProvider) {
        return CDODBUtil.createStore(mappingStrategy, dbAdapter, dbConnectionProvider, null);
    }

    public static IDBStore createStore(IMappingStrategy mappingStrategy, IDBAdapter dbAdapter, IDBConnectionProvider dbConnectionProvider, Map<String, String> properties) {
        DBStore store = new DBStore();
        store.setMappingStrategy(mappingStrategy);
        store.setDBAdapter(dbAdapter);
        store.setDBConnectionProvider(dbConnectionProvider);
        store.setProperties(properties);
        return store;
    }

    public static IMappingStrategy createHorizontalMappingStrategy(boolean auditing) {
        return CDODBUtil.createHorizontalMappingStrategy(auditing, false, false);
    }

    public static IMappingStrategy createHorizontalMappingStrategy(boolean auditing, boolean branching) {
        return CDODBUtil.createHorizontalMappingStrategy(auditing, branching, false);
    }

    public static IMappingStrategy createHorizontalMappingStrategy(boolean auditing, boolean branching, boolean withRanges) {
        if (branching) {
            if (auditing) {
                if (withRanges) {
                    return new HorizontalBranchingMappingStrategyWithRanges();
                }
                return new HorizontalBranchingMappingStrategy();
            }
            throw new IllegalArgumentException("Misconfiguration: Branching requires Auditing!");
        }
        if (auditing) {
            if (withRanges) {
                return new HorizontalAuditMappingStrategyWithRanges();
            }
            return new HorizontalAuditMappingStrategy();
        }
        return new HorizontalNonAuditMappingStrategy();
    }

    public static IMappingStrategy createHorizontalMappingStrategy() {
        return new HorizontalMappingStrategy();
    }

    public static IMappingStrategy createMappingStrategy(String type) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server.db", EXT_POINT_MAPPING_STRATEGIES);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeAttr;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("mappingStrategy".equals(element.getName()) && ObjectUtil.equals((Object)(typeAttr = element.getAttribute("type")), (Object)type)) {
                try {
                    return (IMappingStrategy)element.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static IPreparedStatementCache createStatementCache() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static IPreparedStatementCache createStatementCache(int capacity) {
        throw new UnsupportedOperationException();
    }
}

