/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.branch;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.net4j.util.ObjectUtil;

public final class CDOBranchPointRef
implements Serializable {
    public static final CDOBranchPointRef MAIN_HEAD = CDOBranchRef.MAIN.getHeadRef();
    private static final long serialVersionUID = 1L;
    public static final String URI_SEPARATOR = "#";
    public static final String BASE = "BASE";
    public static final String HEAD = "HEAD";
    private final String branchPath;
    private final long timeStamp;

    public CDOBranchPointRef(CDOBranchPoint branchPoint) {
        this(branchPoint.getBranch().getPathName(), branchPoint.getTimeStamp());
    }

    public CDOBranchPointRef(CDOBranchRef branchRef, long timeStamp) {
        this(branchRef.getBranchPath(), timeStamp);
    }

    public CDOBranchPointRef(String branchPath, long timeStamp) {
        this.branchPath = CDOBranchUtil.sanitizePathName(branchPath).intern();
        this.timeStamp = timeStamp;
    }

    public CDOBranchPointRef(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("CDOClassifierRef.1")) + uri);
        }
        int fragmentSeparator = uri.lastIndexOf(URI_SEPARATOR);
        if (fragmentSeparator == -1) {
            this.branchPath = CDOBranchUtil.sanitizePathName(uri).intern();
            this.timeStamp = 0L;
            return;
        }
        this.branchPath = CDOBranchUtil.sanitizePathName(uri.substring(0, fragmentSeparator)).intern();
        String timeStampSpec = uri.substring(fragmentSeparator + 1);
        this.timeStamp = HEAD.equals(timeStampSpec) ? 0L : (BASE.equals(timeStampSpec) ? -1L : Long.valueOf(timeStampSpec));
    }

    public CDOBranchPointRef(CDODataInput in) throws IOException {
        this(in.readCDOPackageURI(), in.readLong());
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOPackageURI(this.branchPath);
        out.writeLong(this.timeStamp);
    }

    public String getURI() {
        return String.valueOf(this.branchPath) + URI_SEPARATOR + this.getTimeStampSpec();
    }

    public CDOBranchRef getBranchRef() {
        return new CDOBranchRef(this.branchPath);
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getTimeStampSpec() {
        if (this.isHead()) {
            return HEAD;
        }
        if (this.isBase()) {
            return BASE;
        }
        return Long.toString(this.timeStamp);
    }

    public boolean isBase() {
        return this.timeStamp == -1L;
    }

    public boolean isHead() {
        return this.timeStamp == 0L;
    }

    public CDOBranchPoint resolve(CDOBranchManager branchManager) {
        CDOBranch branch = branchManager.getBranch(this.branchPath);
        if (branch == null) {
            return null;
        }
        return branch.getPoint(this.timeStamp);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == CDOBranchPointRef.class) {
            CDOBranchPointRef that = (CDOBranchPointRef)obj;
            return ObjectUtil.equals((Object)this.branchPath, (Object)that.branchPath) && this.timeStamp == that.timeStamp;
        }
        return false;
    }

    public int hashCode() {
        return this.branchPath.hashCode() ^ Long.hashCode(this.timeStamp);
    }

    public String toString() {
        return this.getURI();
    }

    public static interface Provider {
        public CDOBranchPointRef getBranchPointRef();
    }
}

