/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.preferences;

import java.util.ArrayList;
import org.eclipse.bpel.model.terms.BPELTerms;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class BPELPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static String PREFERENCE = "preference";
    Button fUseAnimation;
    Button fShowFreeFormFlow;
    Button fWarnOnLinks;
    Button fAutoFlowLayout;
    Button fSpecCompliantProcess;
    ArrayList<Button> fButtons = new ArrayList(8);

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        result.setLayoutData((Object)data);
        this.fUseAnimation = new Button(result, 32);
        this.fUseAnimation.setText(Messages.BPELPreferencePage_0);
        this.fUseAnimation.setToolTipText(Messages.BPELPreferencePage_0TT);
        this.fUseAnimation.setData(PREFERENCE, (Object)"pref_use_animation");
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fUseAnimation.setLayoutData((Object)data);
        this.fButtons.add(this.fUseAnimation);
        this.fShowFreeFormFlow = new Button(result, 32);
        this.fShowFreeFormFlow.setText(Messages.BPELPreferencePage_1);
        this.fShowFreeFormFlow.setData(PREFERENCE, (Object)"pref_show_freeform_flow");
        this.fShowFreeFormFlow.setToolTipText(Messages.BPELPreferencePage_1TT);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fShowFreeFormFlow.setLayoutData((Object)data);
        this.fButtons.add(this.fShowFreeFormFlow);
        this.fWarnOnLinks = new Button(result, 32);
        this.fWarnOnLinks.setText(Messages.BPELPreferencePage_2);
        this.fWarnOnLinks.setToolTipText(Messages.BPELPreferencePage_2TT);
        this.fWarnOnLinks.setData(PREFERENCE, (Object)"pref_warn_links");
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fWarnOnLinks.setLayoutData((Object)data);
        this.fButtons.add(this.fWarnOnLinks);
        this.fAutoFlowLayout = new Button(result, 32);
        this.fAutoFlowLayout.setText(Messages.BPELPreferencePage_3);
        this.fAutoFlowLayout.setToolTipText(Messages.BPELPreferencePage_3TT);
        this.fAutoFlowLayout.setData(PREFERENCE, (Object)"pref_auto_flow_layout");
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fAutoFlowLayout.setLayoutData((Object)data);
        this.fButtons.add(this.fAutoFlowLayout);
        this.fSpecCompliantProcess = new Button(result, 32);
        this.fSpecCompliantProcess.setText(Messages.BPELPreferencePage_4);
        this.fSpecCompliantProcess.setToolTipText(Messages.BPELPreferencePage_4TT);
        this.fSpecCompliantProcess.setData(PREFERENCE, (Object)"pref_create_spec_compliant");
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSpecCompliantProcess.setLayoutData((Object)data);
        this.fButtons.add(this.fSpecCompliantProcess);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.preferences_page");
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initializeDefaults() {
        this.fUseAnimation.setSelection(BPELUIPlugin.INSTANCE.getPreferenceStore().getDefaultBoolean("pref_use_animation"));
    }

    private void initializeValues() {
        IPreferenceStore store = BPELUIPlugin.INSTANCE.getPreferenceStore();
        for (Button b : this.fButtons) {
            String pref = (String)b.getData(PREFERENCE);
            if (pref == null) continue;
            b.setSelection(store.getBoolean(pref));
        }
    }

    private void storeValues() {
        IPreferenceStore store = BPELUIPlugin.INSTANCE.getPreferenceStore();
        for (Button b : this.fButtons) {
            String pref = (String)b.getData(PREFERENCE);
            if (pref == null) continue;
            store.setValue(pref, b.getSelection());
        }
        BPELTerms.getDefault().savePluginPreferences();
    }
}

