/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.Map;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.auth.UsernameHolder;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.ConnectionEndpointsIndicator;

public interface SessionContext
extends ConnectionEndpointsIndicator,
UsernameHolder,
SessionHeartbeatController,
AttributeStore,
Closeable {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String FALLBACK_SSH_VERSION_PREFIX = "SSH-1.99-";
    public static final int MAX_VERSION_LINE_LENGTH = 256;

    public byte[] getSessionId();

    public boolean isServerSession();

    public String getClientVersion();

    public Map<KexProposalOption, String> getClientKexProposals();

    public String getServerVersion();

    public Map<KexProposalOption, String> getServerKexProposals();

    public KexState getKexState();

    public Map<KexProposalOption, String> getKexNegotiationResult();

    public String getNegotiatedKexParameter(KexProposalOption var1);

    public CipherInformation getCipherInformation(boolean var1);

    public CompressionInformation getCompressionInformation(boolean var1);

    public MacInformation getMacInformation(boolean var1);

    public boolean isAuthenticated();

    public static boolean isValidVersionPrefix(String version) {
        return GenericUtils.isNotEmpty(version) && (version.startsWith(DEFAULT_SSH_VERSION_PREFIX) || version.startsWith(FALLBACK_SSH_VERSION_PREFIX));
    }

    public static boolean isSecureSessionTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        for (KexProposalOption opt : KexProposalOption.CIPHER_PROPOSALS) {
            String value = session.getNegotiatedKexParameter(opt);
            if (!GenericUtils.isEmpty(value) && !"none".equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDataIntegrityTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        for (KexProposalOption opt : KexProposalOption.MAC_PROPOSALS) {
            String value = session.getNegotiatedKexParameter(opt);
            if (!GenericUtils.isEmpty(value)) continue;
            return false;
        }
        return true;
    }
}

