/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.tagexpression;

import java.util.Collection;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.tagexpression.TagExpression;

class TagExpressions {
    TagExpressions() {
    }

    static TagExpression tag(String tag) {
        final TestTag testTag = TestTag.create((String)tag);
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return tags.contains(testTag);
            }

            public String toString() {
                return testTag.getName();
            }
        };
    }

    static TagExpression none() {
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return tags.isEmpty();
            }

            public String toString() {
                return "none()";
            }
        };
    }

    static TagExpression any() {
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return !tags.isEmpty();
            }

            public String toString() {
                return "any()";
            }
        };
    }

    static TagExpression not(final TagExpression toNegate) {
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return !toNegate.evaluate(tags);
            }

            public String toString() {
                return "!" + toNegate + "";
            }
        };
    }

    static TagExpression and(final TagExpression lhs, final TagExpression rhs) {
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return lhs.evaluate(tags) && rhs.evaluate(tags);
            }

            public String toString() {
                return "(" + lhs + " & " + rhs + ")";
            }
        };
    }

    static TagExpression or(final TagExpression lhs, final TagExpression rhs) {
        return new TagExpression(){

            @Override
            public boolean evaluate(Collection<TestTag> tags) {
                return lhs.evaluate(tags) || rhs.evaluate(tags);
            }

            public String toString() {
                return "(" + lhs + " | " + rhs + ")";
            }
        };
    }
}

