/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.impl.SerializableNodeModel;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ResourceStorageLoadable {
    private static final Logger LOG = Logger.getLogger(ResourceStorageLoadable.class);
    private final InputStream in;
    private final boolean storeNodeModel;

    public ResourceStorageLoadable(InputStream in, boolean storeNodeModel) {
        this.in = in;
        this.storeNodeModel = storeNodeModel;
    }

    protected void loadIntoResource(StorageAwareResource resource) throws IOException {
        if (!resource.isLoadedFromStorage()) {
            throw new IllegalStateException("Please use StorageAwareResource#load(ResourceStorageLoadable).");
        }
        try (ZipInputStream zin = new ZipInputStream(this.in);){
            this.loadEntries(resource, zin);
        }
    }

    protected void loadEntries(StorageAwareResource resource, ZipInputStream zipIn) throws IOException {
        zipIn.getNextEntry();
        this.readContents(resource, new BufferedInputStream(zipIn));
        zipIn.getNextEntry();
        this.readResourceDescription(resource, new BufferedInputStream(zipIn));
        if (this.storeNodeModel) {
            zipIn.getNextEntry();
            this.readNodeModel(resource, new BufferedInputStream(zipIn));
        }
    }

    protected void readContents(StorageAwareResource resource, InputStream inputStream) throws IOException {
        new BinaryResourceImpl.EObjectInputStream(inputStream, Collections.emptyMap()){

            public int readCompressedInt() throws IOException {
                this.resourceSet = null;
                return super.readCompressedInt();
            }

            public InternalEObject loadEObject() throws IOException {
                InternalEObject result = super.loadEObject();
                ResourceStorageLoadable.this.handleLoadEObject(result, this);
                return result;
            }
        }.loadResource((Resource)resource);
    }

    protected void handleLoadEObject(InternalEObject loaded, BinaryResourceImpl.EObjectInputStream input) throws IOException {
    }

    protected void readResourceDescription(StorageAwareResource resource, InputStream inputStream) throws IOException {
        try {
            SerializableResourceDescription description = (SerializableResourceDescription)new ObjectInputStream(inputStream).readObject();
            description.updateResourceURI(resource.getURI());
            resource.setResourceDescription(description);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readNodeModel(StorageAwareResource resource, InputStream inputStream) throws IOException {
        SerializableNodeModel serializableNodeModel = new SerializableNodeModel(resource);
        if (!resource.getResourceSet().getURIConverter().exists(resource.getURI(), resource.getResourceSet().getLoadOptions())) {
            LOG.info((Object)("Skipping loading node model for synthetic resource " + resource.getURI()));
            return;
        }
        String completeContent = CharStreams.toString((Readable)new InputStreamReader(resource.getResourceSet().getURIConverter().createInputStream(resource.getURI()), resource.getEncoding()));
        DeserializationConversionContext deserializationContext = new DeserializationConversionContext(resource, completeContent);
        serializableNodeModel.readObjectData(new DataInputStream(inputStream), deserializationContext);
        resource.setParseResult(new ParseResult((EObject)IterableExtensions.head((Iterable)resource.getContents()), serializableNodeModel.root, deserializationContext.hasErrors()));
    }
}

