/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;

public class EObjectDescriptionLookUp
implements ISelectable {
    private volatile Map<QualifiedName, List<IEObjectDescription>> nameToObjects;
    private volatile List<IEObjectDescription> allDescriptions;

    public EObjectDescriptionLookUp(List<IEObjectDescription> allDescriptions) {
        this.setExportedObjects(allDescriptions);
    }

    @Override
    public boolean isEmpty() {
        return this.allDescriptions.isEmpty();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.filter(this.allDescriptions, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom(type, input.getEClass());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(final EObject object) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        final URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI(object);
        return Iterables.filter(this.allDescriptions, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return true;
                }
                return uri.equals(input.getEObjectURI());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName name, boolean ignoreCase) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        QualifiedName lowerCase = name.toLowerCase();
        List<IEObjectDescription> values = this.getNameToObjects().get(lowerCase);
        if (values == null) {
            return Collections.emptyList();
        }
        Object predicate = ignoreCase ? new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom(type, input.getEClass());
            }
        } : new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return name.equals(input.getName()) && EcoreUtil2.isAssignableFrom(type, input.getEClass());
            }
        };
        return Iterables.filter(values, (Predicate)predicate);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return this.allDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExportedObjects(List<IEObjectDescription> allDescriptions) {
        EObjectDescriptionLookUp eObjectDescriptionLookUp = this;
        synchronized (eObjectDescriptionLookUp) {
            this.allDescriptions = allDescriptions;
            this.nameToObjects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<QualifiedName, List<IEObjectDescription>> getNameToObjects() {
        if (this.nameToObjects == null) {
            EObjectDescriptionLookUp eObjectDescriptionLookUp = this;
            synchronized (eObjectDescriptionLookUp) {
                if (this.nameToObjects == null) {
                    HashMap nameToObjects = Maps.newHashMapWithExpectedSize((int)this.allDescriptions.size());
                    if (this.allDescriptions instanceof RandomAccess) {
                        for (int i = 0; i < this.allDescriptions.size(); ++i) {
                            IEObjectDescription description = this.allDescriptions.get(i);
                            this.putIntoMap(nameToObjects, description);
                        }
                    } else {
                        for (IEObjectDescription description : this.allDescriptions) {
                            this.putIntoMap(nameToObjects, description);
                        }
                    }
                    this.nameToObjects = nameToObjects;
                }
            }
        }
        return this.nameToObjects;
    }

    protected void putIntoMap(Map<QualifiedName, List<IEObjectDescription>> nameToObjects, IEObjectDescription description) {
        QualifiedName indexKey = description.getName().toLowerCase();
        ArrayList values = nameToObjects.get(indexKey);
        if (values == null) {
            values = Lists.newArrayListWithExpectedSize((int)2);
            nameToObjects.put(indexKey, values);
        }
        values.add(description);
    }
}

