/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.formatting.IFormatterExtension;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting.INodeModelStreamer;
import org.eclipse.xtext.formatting.impl.AbstractNodeModelFormatter;
import org.eclipse.xtext.formatting.impl.AbstractTokenStream;
import org.eclipse.xtext.formatting.impl.BaseTokenStream;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultNodeModelFormatter
extends AbstractNodeModelFormatter {
    @Inject
    protected IFormatter formatter;
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    protected INodeModelStreamer nodeModelStreamer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INodeModelFormatter.IFormattedRegion format(ICompositeNode root, int offset, int length) {
        ITokenStream fmt;
        AbstractTokenStream abstractTokenStream;
        String indent = this.getIndentation(root, offset);
        TokenStringBuffer buf = new TokenStringBuffer();
        AbstractTokenStream abstractTokenStream2 = abstractTokenStream = offset == 0 ? buf : new FilterFirstWhitespaceStream(buf);
        if (this.formatter instanceof IFormatterExtension) {
            EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor(root);
            if (semanticElement == null) {
                ITextRegion rootRegion = root.getTextRegion();
                return new AbstractNodeModelFormatter.FormattedRegion(rootRegion.getOffset(), rootRegion.getLength(), root.getText());
            }
            fmt = ((IFormatterExtension)((Object)this.formatter)).createFormatterStream(semanticElement, indent, abstractTokenStream, false);
        } else {
            fmt = this.formatter.createFormatterStream(indent, abstractTokenStream, false);
        }
        try {
            ITextRegion range = this.nodeModelStreamer.feedTokenStream(fmt, root, offset, length);
            return new AbstractNodeModelFormatter.FormattedRegion(range.getOffset(), range.getLength(), buf.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIndentation(ICompositeNode root, int fromOffset) {
        if (fromOffset == 0) {
            return "";
        }
        ArrayList<ILeafNode> r = new ArrayList<ILeafNode>();
        for (ILeafNode l : root.getLeafNodes()) {
            if (l.getOffset() >= fromOffset) break;
            r.add(l);
        }
        Pattern p = Pattern.compile("(\\n|\\r)([ \\t]*)");
        for (int i = r.size() - 1; i >= 0; --i) {
            Matcher m = p.matcher(((ILeafNode)r.get(i)).getText());
            if (!m.find()) continue;
            String ind = m.group(2);
            while (m.find()) {
                ind = m.group(2);
            }
            return ind;
        }
        return "";
    }

    protected class FilterFirstWhitespaceStream
    extends BaseTokenStream {
        boolean firstPassed;

        protected FilterFirstWhitespaceStream(ITokenStream out) {
            super(out);
            this.firstPassed = false;
        }

        @Override
        public void writeHidden(EObject grammarElement, String value) throws IOException {
            if (this.firstPassed) {
                this.out.writeHidden(grammarElement, value);
            } else {
                boolean isWhitespace;
                boolean bl = isWhitespace = grammarElement instanceof AbstractRule && DefaultNodeModelFormatter.this.hiddenTokenHelper.isWhitespace((AbstractRule)grammarElement);
                if (!isWhitespace) {
                    this.out.writeHidden(grammarElement, value);
                    this.firstPassed = true;
                }
            }
        }

        @Override
        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            this.firstPassed = true;
            this.out.writeSemantic(grammarElement, value);
        }
    }
}

