/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.PublishedItemsElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.BusinessNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ItemsSummaryTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceInterfaceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorFolderNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class PublishedItemsNode
extends UDDINavigatorFolderNode {
    public PublishedItemsNode(TreeElement element, NodeManager nodeManager, int nodeDepth) {
        super(element, nodeManager, nodeDepth);
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("publishedItems")) {
                    TreeElement treeElement = (TreeElement)event.getParentElement();
                    PublishedItemsNode.this.createChildNode(treeElement);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                TreeElement treeElement = null;
                if (event.getInBoundRelName().equals("publishedItems")) {
                    treeElement = (TreeElement)event.getInboundElement();
                } else if (event.getOutBoundRelName().equals("publishedItems")) {
                    treeElement = (TreeElement)event.getOutBoundElement();
                }
                if (treeElement != null) {
                    PublishedItemsNode.this.removeChildNode(treeElement);
                }
            }
        });
    }

    private final void createChildNode(TreeElement element) {
        PublishedItemsElement publishedItemsElement = (PublishedItemsElement)this.element_;
        UDDINavigatorNode childNode = null;
        switch (publishedItemsElement.getType()) {
            case 0: {
                childNode = new BusinessNode(element, this.nodeManager_, this.nodeDepth_ + 1);
                break;
            }
            case 1: {
                childNode = new ServiceNode(element, this.nodeManager_, this.nodeDepth_ + 1);
                break;
            }
            case 2: {
                childNode = new ServiceInterfaceNode(element, this.nodeManager_, this.nodeDepth_ + 1);
            }
        }
        if (childNode != null) {
            this.addChild(childNode);
        }
    }

    protected final void initTools() {
        PublishedItemsElement publishedItemsElement = (PublishedItemsElement)this.element_;
        UDDIPerspective uddiPerspective = this.nodeManager_.getController().getUDDIPerspective();
        int publishedItemsType = publishedItemsElement.getType();
        switch (publishedItemsType) {
            case 0: {
                new ItemsSummaryTool(this.toolManager_, "uddi/images/businesses_closed_enabled.gif", "uddi/images/businesses_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_BUSINESSES"), publishedItemsType);
                break;
            }
            case 1: {
                new ItemsSummaryTool(this.toolManager_, "uddi/images/services_closed_enabled.gif", "uddi/images/services_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_SERVICES"), publishedItemsType);
                break;
            }
            default: {
                new ItemsSummaryTool(this.toolManager_, "uddi/images/service_interfaces_closed_enabled.gif", "uddi/images/service_interfaces_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_SERVICE_INTERFACES"), publishedItemsType);
            }
        }
    }

    public String getOpenImagePath() {
        PublishedItemsElement publishedItemsElement = (PublishedItemsElement)this.element_;
        int publishedItemsType = publishedItemsElement.getType();
        switch (publishedItemsType) {
            case 0: {
                return "uddi/images/businesses_open_highlighted.gif";
            }
            case 1: {
                return "uddi/images/services_open_highlighted.gif";
            }
            case 2: {
                return "uddi/images/service_interfaces_open_highlighted.gif";
            }
        }
        return super.getOpenImagePath();
    }

    public String getClosedImagePath() {
        PublishedItemsElement publishedItemsElement = (PublishedItemsElement)this.element_;
        int publishedItemsType = publishedItemsElement.getType();
        switch (publishedItemsType) {
            case 0: {
                return "uddi/images/businesses_closed_highlighted.gif";
            }
            case 1: {
                return "uddi/images/services_closed_highlighted.gif";
            }
            case 2: {
                return "uddi/images/service_interfaces_closed_highlighted.gif";
            }
        }
        return super.getClosedImagePath();
    }
}

