/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class FormatHandler
extends AbstractHandler
implements IHandler {
    protected IStructuredSelection fSelection;
    private MultiStatus fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);

    public void dispose() {
    }

    private IWorkbenchSiteProgressService getActiveProgressService() {
        IWorkbenchPart activePart;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbenchSiteProgressService service = null;
        if (PlatformUI.isWorkbenchRunning() && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) != null) {
            service = (IWorkbenchSiteProgressService)activePart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        }
        return service;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            boolean available = false;
            Object[] elements = this.fSelection.toArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IResource && (available = this.processorAvailable((IResource)elements[i]))) break;
                ++i;
            }
        }
        if (this.fSelection != null && !this.fSelection.isEmpty() && (job = this.getJob()) != null) {
            IWorkbenchSiteProgressService progressService = this.getActiveProgressService();
            if (progressService != null) {
                progressService.schedule(job);
            } else {
                job.schedule();
            }
        }
        return null;
    }

    protected void format(IProgressMonitor monitor, IFile file) {
        if (monitor == null || monitor.isCanceled()) {
            return;
        }
        try {
            IContentType contentType;
            IStructuredFormatProcessor formatProcessor;
            monitor.beginTask("", 100);
            IContentDescription contentDescription = file.getContentDescription();
            monitor.worked(5);
            if (!(contentDescription == null || (formatProcessor = this.getFormatProcessor((contentType = contentDescription.getContentType()).getId())) == null || monitor != null && monitor.isCanceled())) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_3, (Object[])new String[]{file.getFullPath().toString().substring(1)});
                monitor.subTask(message);
                formatProcessor.setProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 95));
                formatProcessor.formatFile(file);
            }
            monitor.done();
        }
        catch (MalformedInputExceptionWithDetail e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_5, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void format(final IProgressMonitor monitor, IResource resource) {
        if (resource instanceof IFile) {
            final IFile file = (IFile)resource;
            monitor.beginTask("", 20);
            try {
                try {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    ITextFileBuffer buffer = null;
                    try {
                        if (manager != null) {
                            manager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            buffer = manager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
                        }
                        if (buffer != null && buffer.isShared()) {
                            Display display = this.getDisplay();
                            if (display != null) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        FormatHandler.this.format((IProgressMonitor)new SubProgressMonitor(monitor, 18), file);
                                    }
                                });
                            }
                        } else {
                            this.format((IProgressMonitor)new SubProgressMonitor(monitor, 18), file);
                        }
                    }
                    finally {
                        if (manager != null) {
                            manager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    monitor.done();
                    return;
                }
                catch (CoreException e) {
                    String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
                    this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
                    if (monitor == null) return;
                    monitor.done();
                }
                return;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        if (!(resource instanceof IContainer)) return;
        IContainer container = (IContainer)resource;
        try {
            IResource[] members = container.members();
            monitor.beginTask("", members.length);
            int i = 0;
            while (i < members.length) {
                if (monitor != null && !monitor.isCanceled()) {
                    this.format((IProgressMonitor)new SubProgressMonitor(monitor, 1), members[i]);
                }
                ++i;
            }
            monitor.done();
            return;
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    protected IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
    }

    protected Job getJob() {
        return new FormatJob(SSEUIMessages.FormatActionDelegate_jobName);
    }

    protected void process(IProgressMonitor monitor, IResource resource) {
        monitor.beginTask("", 100);
        this.format((IProgressMonitor)new SubProgressMonitor(monitor, 98), resource);
        try {
            resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        monitor.done();
    }

    protected boolean processorAvailable(IResource resource) {
        boolean result;
        block8: {
            result = false;
            if (resource.isAccessible()) {
                try {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IStructuredFormatProcessor formatProcessor = null;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription != null) {
                            IContentType contentType = contentDescription.getContentType();
                            formatProcessor = this.getFormatProcessor(contentType.getId());
                        }
                        if (formatProcessor != null) {
                            result = true;
                        }
                        break block8;
                    }
                    if (!(resource instanceof IContainer)) break block8;
                    IContainer container = (IContainer)resource;
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        boolean available = this.processorAvailable(members[i]);
                        if (available) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return result;
    }

    class FormatJob
    extends Job {
        public FormatJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Object[] elements = FormatHandler.this.fSelection.toArray();
            monitor.beginTask("", elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IResource) {
                    FormatHandler.this.process((IProgressMonitor)new SubProgressMonitor(monitor, 1), (IResource)elements[i]);
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
            if (FormatHandler.this.fErrorStatus.getChildren().length > 0) {
                status = FormatHandler.this.fErrorStatus;
                FormatHandler.this.fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);
            }
            return status;
        }
    }
}

