/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.editor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.json.ui.internal.Logger;

public class JSONEditorPluginImageHelper {
    private static JSONEditorPluginImageHelper instance = null;
    private static final String IMAGE_DIR = "wtp-json-images";
    private final Map<ImageDescriptor, URL> fURLMap = new HashMap<ImageDescriptor, URL>();
    private final File fTempDir = this.getTempDir();
    private int fImageCount = 0;
    private Map<String, ImageDescriptor> fImageDescRegistry = null;
    private final String PLUGINID = "org.eclipse.wst.json.ui";

    public static synchronized JSONEditorPluginImageHelper getInstance() {
        if (instance == null) {
            instance = new JSONEditorPluginImageHelper();
        }
        return instance;
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = this.getImageDescriptor(resource);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                this.getImageRegistry().put(resource, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.json.ui", (String)imageFilePath);
        if (imageDescriptor != null) {
            this.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public Image getImage(short nodeType) {
        String imageName = this.getImageName(nodeType);
        return imageName != null ? this.getImage(imageName) : null;
    }

    public ImageDescriptor getImageDescriptor(short nodeType) {
        String imageName = this.getImageName(nodeType);
        return imageName != null ? this.getImageDescriptor(imageName) : null;
    }

    private String getImageName(short nodeType) {
        switch (nodeType) {
            case 0: {
                return "icons/full/obj16/json-object.png";
            }
            case 1: {
                return "icons/full/obj16/json-array.png";
            }
            case 5: {
                return "icons/full/obj16/json-boolean.png";
            }
            case 6: {
                return "icons/full/obj16/json-null.png";
            }
            case 4: {
                return "icons/full/obj16/json-number.png";
            }
            case 3: {
                return "icons/full/obj16/json-string.png";
            }
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(JSONSchemaType type) {
        String imageName = this.getImageName(type);
        return imageName != null ? this.getImageDescriptor(imageName) : null;
    }

    public Image getImage(JSONSchemaType type) {
        String imageName = this.getImageName(type);
        return imageName != null ? this.getImage(imageName) : null;
    }

    private String getImageName(JSONSchemaType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case Object: {
                return "icons/full/obj16/json-object.png";
            }
            case Array: {
                return "icons/full/obj16/json-array.png";
            }
            case Boolean: {
                return "icons/full/obj16/json-boolean.png";
            }
            case Null: {
                return "icons/full/obj16/json-null.png";
            }
            case Number: {
                return "icons/full/obj16/json-number.png";
            }
            case String: {
                return "icons/full/obj16/json-string.png";
            }
        }
        return null;
    }

    public Image getImage(String resource) {
        Image image = this.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        ImageDescriptor imageDescriptor = this.getImageDescriptorRegistry().get(resource);
        if (imageDescriptor == null) {
            imageDescriptor = this.createImageDescriptor(resource);
        }
        return imageDescriptor;
    }

    private Map<String, ImageDescriptor> getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap<String, ImageDescriptor>();
        }
        return this.fImageDescRegistry;
    }

    private ImageRegistry getImageRegistry() {
        return JSONUIPlugin.getDefault().getImageRegistry();
    }

    public URL getImageURL(ImageDescriptor descriptor) {
        if (this.fTempDir == null) {
            return null;
        }
        URL url = this.fURLMap.get(descriptor);
        if (url != null) {
            return url;
        }
        File imageFile = this.getNewFile();
        ImageData imageData = descriptor.getImageData();
        if (imageData == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        loader.save(imageFile.getAbsolutePath(), 5);
        try {
            url = imageFile.toURI().toURL();
            this.fURLMap.put(descriptor, url);
            return url;
        }
        catch (MalformedURLException e) {
            Logger.logException("Failed to create image directory ", e);
            return null;
        }
    }

    private File getNewFile() {
        File file;
        while ((file = new File(this.fTempDir, String.valueOf(String.valueOf(this.getImageCount())) + ".png")).exists()) {
        }
        return file;
    }

    private synchronized int getImageCount() {
        return this.fImageCount++;
    }

    private File getTempDir() {
        File imageDir;
        block5: {
            try {
                imageDir = JSONUIPlugin.getDefault().getStateLocation().append(IMAGE_DIR).toFile();
                if (imageDir.exists()) {
                    this.delete(imageDir);
                }
                if (!imageDir.exists()) {
                    imageDir.mkdir();
                }
                if (imageDir.isDirectory()) break block5;
                Logger.log(4, "Failed to create image directory " + imageDir.toString());
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return imageDir;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            int i = 0;
            while (i < listFiles.length) {
                this.delete(listFiles[i]);
                ++i;
            }
        }
        file.delete();
    }
}

