/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.source.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.debug.internal.ui.source.contentassist.ScriptContext;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class JavaScriptContentAssistProcessor
implements IContentAssistProcessor {
    private CompletionProposalCollector fCollector;
    private IContextInformationValidator fValidator;
    private TemplateEngine fJavaEngine;
    private TemplateEngine fStatementEngine;
    private String fErrorMessage = null;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private ScriptContext fContext;

    public JavaScriptContentAssistProcessor(ScriptContext context) {
        this.fContext = context;
        TemplateContextType contextType = JavaScriptPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        if (contextType != null) {
            this.fJavaEngine = new TemplateEngine(contextType);
        }
        if ((contextType = JavaScriptPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript")) != null) {
            this.fStatementEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fCollector != null) {
            return this.fCollector.getErrorMessage();
        }
        return null;
    }

    private void setErrorMessage(String string) {
        String error = string;
        if (error != null && error.length() == 0) {
            error = null;
        }
        this.fErrorMessage = error;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.setErrorMessage(null);
        try {
            ArrayList<Object> total = new ArrayList<Object>();
            ITypeRoot root = this.fContext.getJavaScriptRoot();
            if (root != null) {
                IJavaScriptProject project = root.getJavaScriptProject();
                ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                this.configureResultCollector(project, selection);
                root.codeComplete(documentOffset, (CompletionRequestor)this.fCollector);
                total.addAll(Arrays.asList(this.fCollector.getJavaCompletionProposals()));
            }
            if (this.fJavaEngine != null) {
                this.fJavaEngine.reset();
                this.fJavaEngine.complete(viewer, documentOffset, null);
                total.addAll(Arrays.asList(this.fJavaEngine.getResults()));
            }
            if (this.fStatementEngine != null) {
                this.fStatementEngine.reset();
                this.fStatementEngine.complete(viewer, documentOffset, null);
                total.addAll(Arrays.asList(this.fStatementEngine.getResults()));
            }
            IJavaCompletionProposal[] iJavaCompletionProposalArray = this.order(total.toArray(new IJavaCompletionProposal[total.size()]));
            return iJavaCompletionProposalArray;
        }
        catch (CoreException x) {
            this.setErrorMessage(x.getStatus().getMessage());
        }
        finally {
            this.releaseCollector();
        }
        return null;
    }

    private IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private void configureResultCollector(IJavaScriptProject project, ITextSelection selection) {
        this.fCollector = new CompletionProposalCollector(project);
        if (selection.getLength() != 0) {
            this.fCollector.setReplacementLength(selection.getLength());
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    private void releaseCollector() {
        if (this.fCollector != null && this.fCollector.getErrorMessage().length() > 0 && this.fErrorMessage != null) {
            this.setErrorMessage(this.fCollector.getErrorMessage());
        }
        this.fCollector = null;
    }
}

