/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist.select;

import org.eclipse.wst.jsdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;

public class SelectionJavadoc
extends Javadoc {
    Expression selectedNode;

    public SelectionJavadoc(int sourceStart, int sourceEnd) {
        super(sourceStart, sourceEnd);
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        super.print(indent, output);
        if (this.selectedNode != null) {
            TypeReference typeRef;
            String selectedString = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.selectedNode;
                selectedString = fieldRef.methodBinding != null ? "<SelectOnMethod:" : "<SelectOnField:";
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                selectedString = "<SelectOnMethod:";
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                selectedString = "<SelectOnConstructor:";
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                selectedString = "<SelectOnLocalVariable:";
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                typeRef = (JavadocSingleTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    selectedString = "<SelectOnType:";
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                typeRef = (JavadocQualifiedTypeReference)this.selectedNode;
                if (((JavadocQualifiedTypeReference)typeRef).packageBinding == null) {
                    selectedString = "<SelectOnType:";
                }
            } else {
                selectedString = "<SelectOnType:";
            }
            int pos = output.length() - 3;
            output.replace(pos - 2, pos, String.valueOf(selectedString) + this.selectedNode + '>');
        }
        return output;
    }

    private void internalResolve(Scope scope) {
        if (this.selectedNode != null) {
            switch (scope.kind) {
                case 3: {
                    this.selectedNode.resolveType((ClassScope)scope);
                    break;
                }
                case 2: {
                    this.selectedNode.resolveType((MethodScope)scope);
                }
            }
            Binding binding = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.selectedNode;
                binding = fieldRef.binding;
                if (binding == null && fieldRef.methodBinding != null) {
                    binding = fieldRef.methodBinding;
                }
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                binding = ((JavadocMessageSend)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                binding = ((JavadocAllocationExpression)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                binding = ((JavadocSingleNameReference)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference typeRef = (JavadocSingleTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    binding = typeRef.resolvedType;
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference typeRef = (JavadocQualifiedTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    binding = typeRef.resolvedType;
                }
            } else {
                binding = this.selectedNode.resolvedType;
            }
            throw new SelectionNodeFound(binding);
        }
    }

    @Override
    public void resolve(ClassScope scope) {
        this.internalResolve(scope);
    }

    @Override
    public void resolve(MethodScope scope) {
        this.internalResolve(scope);
    }
}

