/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.OpenFunctionAction;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.VariableBasedAction;

public abstract class LoadFullValueAction
extends VariableBasedAction {
    protected LoadFullValueAction(VariableBasedAction.ElementHandler elementHandler) {
        super(elementHandler);
    }

    @Override
    protected Runnable createRunnable(final VariableBasedAction.VariableWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        ConnectedTargetData connectedTargetData = wrapper.getConnectedTargetData();
        if (connectedTargetData == null) {
            return null;
        }
        final Value value = wrapper.getValue();
        if (value == null || !value.isTruncated()) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                Value.ReloadValueCallback callback = new Value.ReloadValueCallback(){

                    public void done(boolean changed) {
                        if (changed) {
                            DebugEvent event = new DebugEvent((Object)wrapper.getDebugElement(), 16, 512);
                            DebugTargetImpl.fireDebugEvent((DebugEvent)event);
                        }
                    }
                };
                value.reloadBiggerValue(callback);
            }
        };
    }

    public static class ForExpression
    extends LoadFullValueAction {
        public ForExpression() {
            super(OpenFunctionAction.EXPRESSION_VIEW_ELEMENT_HANDLER);
        }
    }

    public static class ForVariable
    extends LoadFullValueAction {
        public ForVariable() {
            super(OpenFunctionAction.VARIABLE_VIEW_ELEMENT_HANDLER);
        }
    }
}

