/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;

public class MonitorTableLabelProvider
implements ITableLabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            IMonitor monitor = (IMonitor)element;
            if (monitor.isRunning()) {
                return MonitorUIPlugin.getImage("monitorOn");
            }
            return MonitorUIPlugin.getImage("monitorOff");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IMonitor monitor = (IMonitor)element;
        if (columnIndex == 0) {
            if (monitor.isRunning()) {
                return Messages.started;
            }
            return Messages.stopped;
        }
        if (columnIndex == 1) {
            return String.valueOf(monitor.getRemoteHost()) + ":" + monitor.getRemotePort();
        }
        if (columnIndex == 2) {
            return monitor.getProtocol();
        }
        if (columnIndex == 3) {
            return String.valueOf(monitor.getLocalPort());
        }
        if (columnIndex == 4) {
            if (monitor.isAutoStart()) {
                return Messages.yes;
            }
            return Messages.no;
        }
        return "X";
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

