/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CComboSelectionDialog
extends Dialog {
    CCombo combo;
    private final String[] fAllowedStrings;
    private final int fInitialSelectionIndex;
    private final String fLabelText;
    int fSelectionIndex = -1;
    private final String fShellTitle;
    String fStringValue = null;
    IInputValidator fValidator;

    public CComboSelectionDialog(Shell parentShell, String shellTitle, String labelText, String[] comboStrings, int initialSelectionIndex, IInputValidator validator) {
        super(parentShell);
        Assert.isNotNull((Object)shellTitle);
        Assert.isNotNull((Object)labelText);
        Assert.isTrue((initialSelectionIndex >= -1 && initialSelectionIndex <= comboStrings.length ? 1 : 0) != 0);
        this.fShellTitle = shellTitle;
        this.fLabelText = labelText;
        this.fAllowedStrings = comboStrings;
        this.fInitialSelectionIndex = initialSelectionIndex;
        this.fValidator = validator;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        if (this.combo != null && result != null) {
            this.getButton(1).addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.character == '\t' && e.stateMask == 0) {
                        CComboSelectionDialog.this.combo.setFocus();
                    }
                }
            });
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.fShellTitle);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        innerComposite.setLayout((Layout)gl);
        Label label = new Label(innerComposite, 0);
        label.setText(this.fLabelText);
        label.setLayoutData((Object)new GridData());
        this.combo = new CCombo(innerComposite, 2048);
        this.combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && e.stateMask == 0) {
                    CComboSelectionDialog.this.fStringValue = CComboSelectionDialog.this.combo.getText();
                    CComboSelectionDialog.this.setReturnCode(0);
                    CComboSelectionDialog.this.updateSelectionIndex();
                    CComboSelectionDialog.this.close();
                } else if (e.character == '\t') {
                    if (e.stateMask == 131072) {
                        CComboSelectionDialog.this.combo.traverse(8);
                    } else {
                        CComboSelectionDialog.this.combo.traverse(16);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CComboSelectionDialog.this.fStringValue = CComboSelectionDialog.this.combo.getText();
                if (CComboSelectionDialog.this.getButton(0) != null) {
                    String errorMessage = null;
                    if (CComboSelectionDialog.this.fValidator != null) {
                        errorMessage = CComboSelectionDialog.this.fValidator.isValid(CComboSelectionDialog.this.combo.getText());
                    }
                    CComboSelectionDialog.this.getButton(0).setEnabled(errorMessage == null);
                }
            }
        });
        int i = 0;
        while (i < this.fAllowedStrings.length) {
            this.combo.add(this.fAllowedStrings[i]);
            ++i;
        }
        this.combo.select(this.fInitialSelectionIndex);
        this.fSelectionIndex = this.combo.getSelectionIndex();
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(this.getMaxStringLength() + 10);
        this.combo.setLayoutData((Object)gd);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CComboSelectionDialog.this.fSelectionIndex = CComboSelectionDialog.this.combo.getSelectionIndex();
                CComboSelectionDialog.this.fStringValue = CComboSelectionDialog.this.combo.getText();
            }
        });
        CComboSelectionDialog.applyDialogFont((Control)composite);
        this.combo.setFocus();
        return composite;
    }

    private int getMaxStringLength() {
        int max = 0;
        int i = 0;
        while (i < this.fAllowedStrings.length) {
            max = Math.max(max, this.fAllowedStrings[i].length());
            ++i;
        }
        return max;
    }

    public int getSelectionIndex() {
        return this.fSelectionIndex;
    }

    public String getStringValue() {
        return this.fStringValue;
    }

    protected void okPressed() {
        this.updateSelectionIndex();
        super.okPressed();
    }

    public void setSelectionIndex(int i) {
        this.fSelectionIndex = i;
    }

    public void setStringValue(String string) {
        this.fStringValue = string;
    }

    void updateSelectionIndex() {
        if (this.fSelectionIndex >= 0) {
            boolean selectedString = false;
            int i = 0;
            while (i < this.fAllowedStrings.length) {
                selectedString = selectedString || this.fAllowedStrings[i].equals(this.fStringValue);
                ++i;
            }
            if (!selectedString) {
                this.fSelectionIndex = -1;
            }
        }
    }
}

