/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.grid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

public class GridConvertionHelper {
    private GridConvertionHelper() {
    }

    public static List<ComponentGroup> buildGroups(List<? extends IAbstractComponentInfo> components, boolean horizontal) {
        ArrayList groupComponents = Lists.newArrayList();
        for (IAbstractComponentInfo iAbstractComponentInfo : components) {
            ComponentInGroup groupComponent = new ComponentInGroup(iAbstractComponentInfo, iAbstractComponentInfo.getModelBounds(), horizontal);
            groupComponents.add(groupComponent);
        }
        return GridConvertionHelper.buildGroups(groupComponents);
    }

    private static List<ComponentGroup> buildGroups(List<ComponentInGroup> components) {
        Collections.sort(components, new Comparator<ComponentInGroup>(){

            @Override
            public int compare(ComponentInGroup o1, ComponentInGroup o2) {
                return o1.getMin() - o2.getMin();
            }
        });
        ArrayList groups = Lists.newArrayList();
        for (ComponentInGroup component : components) {
            ComponentGroup group = new ComponentGroup();
            int value = component.getMin();
            for (ComponentInGroup component2 : components) {
                if (!component2.contains(value)) continue;
                group.add(component2);
            }
            groups.add(group);
        }
        Iterator I = groups.iterator();
        while (I.hasNext()) {
            ComponentGroup subSetGroup = (ComponentGroup)I.next();
            if (!GridConvertionHelper.isSubGroupInGroups(subSetGroup, groups)) continue;
            I.remove();
        }
        return groups;
    }

    private static boolean isSubGroupInGroups(ComponentGroup subSetGroup, List<ComponentGroup> groups) {
        for (ComponentGroup superSetGroup : groups) {
            if (superSetGroup == subSetGroup || !superSetGroup.getComponents().containsAll(subSetGroup.getComponents())) continue;
            return true;
        }
        return false;
    }

    public static void sortGroups(final List<ComponentGroup> groups) {
        Collections.sort(groups, new Comparator<ComponentGroup>(){

            @Override
            public int compare(ComponentGroup group_1, ComponentGroup group_2) {
                int value_1 = group_1.getMinOfBegins(groups);
                int value_2 = group_2.getMinOfBegins(groups);
                return value_1 - value_2;
            }
        });
    }

    public static void sortGroupsByTranspose(List<ComponentGroup> groups, List<ComponentGroup> t_groups) {
        for (ComponentGroup group : groups) {
            GridConvertionHelper.sortGroupByTranspose(group, t_groups);
        }
    }

    private static void sortGroupByTranspose(ComponentGroup group, final List<ComponentGroup> t_groups) {
        Collections.sort(group.getComponents(), new Comparator<ComponentInGroup>(){

            @Override
            public int compare(ComponentInGroup component_1, ComponentInGroup component_2) {
                return this.findTComponent(component_1).getMin() - this.findTComponent(component_2).getMin();
            }

            private ComponentInGroup findTComponent(ComponentInGroup component) {
                for (ComponentGroup tGroup : t_groups) {
                    for (ComponentInGroup tComponent : tGroup.getComponents()) {
                        if (!tComponent.equals(component)) continue;
                        return tComponent;
                    }
                }
                throw new IllegalStateException("Can not find 't' for component: " + component);
            }
        });
    }

    public static void updateBoundsGaps(List<ComponentGroup> groups, boolean addGaps) {
        ArrayList newGroups = Lists.newArrayList();
        int i = 0;
        while (i < groups.size()) {
            ComponentGroup group = groups.get(i);
            group.m_min = group.getMinOfBegins(groups);
            group.m_max = group.getMaxOfEnds(groups);
            if (addGaps) {
                if (i == 0) {
                    if (group.m_min > 0) {
                        ComponentGroup gapGroup = new ComponentGroup();
                        gapGroup.m_min = 0;
                        gapGroup.m_max = group.m_min;
                        newGroups.add(gapGroup);
                    }
                } else {
                    ComponentGroup prevGroup = groups.get(i - 1);
                    if (group.m_min - prevGroup.m_max > 0) {
                        ComponentGroup gapGroup = new ComponentGroup();
                        gapGroup.m_min = prevGroup.m_max;
                        gapGroup.m_max = group.m_min;
                        newGroups.add(gapGroup);
                        for (ComponentInGroup component : prevGroup.getComponents()) {
                            if (!group.contains(component)) continue;
                            gapGroup.add(component);
                        }
                    }
                }
            }
            newGroups.add(group);
            ++i;
        }
        groups.clear();
        groups.addAll(newGroups);
    }

    public static ComponentGroup getBeginForComponent(List<ComponentGroup> groups, ComponentInGroup component) {
        for (ComponentGroup group : groups) {
            if (!group.contains(component)) continue;
            return group;
        }
        throw new IllegalStateException("Can not find group for component: " + component);
    }

    public static ComponentGroup getEndForComponent(List<ComponentGroup> groups, ComponentInGroup component) {
        ComponentGroup lastGroup = null;
        for (ComponentGroup group : groups) {
            if (!group.contains(component)) continue;
            lastGroup = group;
        }
        Assert.isNotNull(lastGroup, "Can not find group for component: " + component);
        return lastGroup;
    }

    public static class ComponentGroup {
        private final List<ComponentInGroup> m_components = Lists.newArrayList();
        private int m_min;
        private int m_max;

        public String toString() {
            return this.m_components + "(" + this.m_min + "," + this.m_max + ")";
        }

        public int getMin() {
            return this.m_min;
        }

        public int getMax() {
            return this.m_max;
        }

        public int getSize() {
            return this.m_max - this.m_min;
        }

        public List<ComponentInGroup> getComponents() {
            return this.m_components;
        }

        private void add(ComponentInGroup component) {
            if (!this.contains(component)) {
                this.m_components.add(component);
            }
        }

        private int getMinOfBegins(List<ComponentGroup> groups) {
            int result = Integer.MAX_VALUE;
            for (ComponentInGroup component : this.m_components) {
                if (GridConvertionHelper.getBeginForComponent(groups, component) != this) continue;
                result = Math.min(result, component.getMin());
            }
            return result;
        }

        private int getMaxOfEnds(List<ComponentGroup> groups) {
            int result = Integer.MIN_VALUE;
            for (ComponentInGroup component : this.m_components) {
                if (GridConvertionHelper.getEndForComponent(groups, component) != this) continue;
                result = Math.max(result, component.getMax());
            }
            return result;
        }

        private boolean contains(ComponentInGroup component) {
            return this.m_components.indexOf(component) != -1;
        }
    }

    public static final class ComponentInGroup {
        private final IAbstractComponentInfo m_component;
        private final int m_min;
        private final int m_max;

        private ComponentInGroup(IAbstractComponentInfo component, Rectangle bounds, boolean horizontal) {
            this.m_component = component;
            int width = Math.max(1, bounds.width);
            int height = Math.max(1, bounds.height);
            if (horizontal) {
                this.m_min = bounds.x;
                this.m_max = bounds.x + width;
            } else {
                this.m_min = bounds.y;
                this.m_max = bounds.y + height;
            }
        }

        public int hashCode() {
            return this.m_component.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComponentInGroup) {
                return this.m_component == ((ComponentInGroup)obj).m_component;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getComponentName()) + "(" + this.m_min + "," + this.m_max + ")";
        }

        private String getComponentName() {
            try {
                return (String)ScriptUtils.evaluate("getVariableSupport().getComponentName()", this.m_component);
            }
            catch (Throwable e) {
                return this.m_component.toString();
            }
        }

        public IAbstractComponentInfo getComponent() {
            return this.m_component;
        }

        private int getMin() {
            return this.m_min;
        }

        private int getMax() {
            return this.m_max;
        }

        private boolean contains(int value) {
            return this.m_min <= value && value < this.m_max;
        }
    }
}

