/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.xml.model.IRootProcessor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class XmlObjectRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new XmlObjectRootProcessor();

    private XmlObjectRootProcessor() {
    }

    public void process(final XmlObjectInfo root) throws Exception {
        root.addBroadcastListener(new ObjectEventListener(){

            public void dispose() throws Exception {
                root.onHierarchyDispose();
            }
        });
        root.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof XmlObjectInfo) {
                    XmlObjectInfo xObject = (XmlObjectInfo)object;
                    String visibilityTreeString = XmlObjectUtils.getParameter(xObject, "visible.inTree");
                    if (visibilityTreeString != null) {
                        visible[0] = Boolean.parseBoolean(visibilityTreeString);
                    } else {
                        String visibilityString = XmlObjectUtils.getParameter(xObject, "visible");
                        if (visibilityString != null) {
                            visible[0] = Boolean.parseBoolean(visibilityString);
                        }
                    }
                }
            }
        });
        root.addBroadcastListener(new ObjectInfoChildGraphical(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof XmlObjectInfo) {
                    XmlObjectInfo xObject = (XmlObjectInfo)object;
                    String visibilityGraphString = XmlObjectUtils.getParameter(xObject, "visible.inGraphical");
                    if (visibilityGraphString != null) {
                        visible[0] = Boolean.parseBoolean(visibilityGraphString);
                    } else {
                        String visibilityString = XmlObjectUtils.getParameter(xObject, "visible");
                        if (visibilityString != null) {
                            visible[0] = Boolean.parseBoolean(visibilityString);
                        }
                    }
                }
            }
        });
        root.addBroadcastListener(new ObjectInfoPresentationDecorateText(){

            public void invoke(ObjectInfo object, String[] text) throws Exception {
                XmlObjectInfo xObject;
                IPreferenceStore preferences;
                if (object instanceof XmlObjectInfo && (preferences = (xObject = (XmlObjectInfo)object).getDescription().getToolkit().getPreferences()).getBoolean("general.showTextPropertySuffix")) {
                    XmlObjectRootProcessor.broadcast_presentation_decorateText(xObject, text);
                }
            }
        });
    }

    private static void broadcast_presentation_decorateText(XmlObjectInfo object, String[] text) throws Exception {
        Property[] propertyArray = object.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericPropertyImpl genericProperty;
            Property property = propertyArray[n2];
            if (property instanceof GenericPropertyImpl && (genericProperty = (GenericPropertyImpl)property).hasTrueTag("isText") && genericProperty.getObject() == object && genericProperty.isModified()) {
                String suffix = (String)genericProperty.getValue();
                text[0] = String.valueOf(text[0]) + " - \"" + suffix + "\"";
                break;
            }
            ++n2;
        }
    }
}

