/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictResolver;

public class FixedPriorityConflictSet
implements ChangeableConflictSet {
    private final Map<Integer, Set<Activation<?>>> priorityBuckets;
    private Map<RuleSpecification<?>, Integer> priorityMap;
    private FixedPriorityConflictResolver resolver;
    private final int defaultPriority;

    public FixedPriorityConflictSet(FixedPriorityConflictResolver resolver, Map<RuleSpecification<?>, Integer> priorities) {
        this(resolver, priorities, 0);
    }

    public FixedPriorityConflictSet(FixedPriorityConflictResolver resolver, Map<RuleSpecification<?>, Integer> priorities, int defaultPriority) {
        this.resolver = resolver;
        this.defaultPriority = defaultPriority;
        Preconditions.checkArgument((priorities != null ? 1 : 0) != 0, (String)"Priority map cannot be null!");
        this.priorityMap = new HashMap(priorities);
        this.priorityBuckets = new TreeMap();
    }

    @Override
    public Activation<?> getNextActivation() {
        Collection<Activation<?>> firstBucket = this.getFirstBucket();
        if (!firstBucket.isEmpty()) {
            return firstBucket.iterator().next();
        }
        return null;
    }

    private Collection<Activation<?>> getFirstBucket() {
        if (this.priorityBuckets.isEmpty()) {
            return Collections.emptySet();
        }
        Integer firstKey = this.priorityBuckets.keySet().iterator().next();
        Collection firstBucket = this.priorityBuckets.get(firstKey);
        return firstBucket;
    }

    @Override
    public boolean addActivation(Activation<?> activation) {
        Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (String)"Activation cannot be null!");
        return this.addActivation(activation, this.getRulePriority(activation));
    }

    @Override
    public boolean removeActivation(Activation<?> activation) {
        Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (String)"Activation cannot be null!");
        return this.removeActivation(activation, this.getRulePriority(activation));
    }

    protected boolean addActivation(Activation<?> activation, Integer priority) {
        return this.priorityBuckets.computeIfAbsent(priority, pr -> new HashSet()).add(activation);
    }

    protected boolean removeActivation(Activation<?> activation, Integer priority) {
        Set<Activation<?>> bucket = this.priorityBuckets.get(priority);
        if (bucket == null) {
            return false;
        }
        boolean removed = bucket.remove(activation);
        if (bucket.isEmpty()) {
            this.priorityBuckets.remove(priority);
        }
        return removed;
    }

    protected void setPriority(RuleSpecification<?> specification, int priority) {
        Preconditions.checkArgument((specification != null ? 1 : 0) != 0, (String)"Specification cannot be null");
        Integer oldPriority = this.getRulePriority(specification);
        this.priorityMap.put(specification, priority);
        Set oldBucket = this.priorityBuckets.get(oldPriority);
        if (oldBucket != null) {
            Set removed = oldBucket.stream().filter(act -> specification.equals(act.getInstance().getSpecification())).collect(Collectors.toSet());
            oldBucket.removeAll(removed);
            if (oldBucket.isEmpty()) {
                this.priorityBuckets.remove(oldPriority);
            }
            this.priorityBuckets.computeIfAbsent(priority, pr -> new HashSet()).addAll(removed);
        }
    }

    @Override
    public FixedPriorityConflictResolver getConflictResolver() {
        return this.resolver;
    }

    @Override
    public Set<Activation<?>> getNextActivations() {
        return Collections.unmodifiableSet(new HashSet(this.getFirstBucket()));
    }

    @Override
    public Set<Activation<?>> getConflictingActivations() {
        return Collections.unmodifiableSet(this.priorityBuckets.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    protected Integer getRulePriority(Activation<?> activation) {
        RuleSpecification<?> specification = activation.getInstance().getSpecification();
        return this.getRulePriority(specification);
    }

    protected Integer getRulePriority(RuleSpecification<?> specification) {
        return this.priorityMap.getOrDefault(specification, this.defaultPriority);
    }
}

