/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * @author Abel Hegedus
 */
@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryResultTreeMatcher<MATCH extends IPatternMatch> implements IFilteredMatcherContent<MATCH> {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryResultTreeInput parent;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final ViatraQueryMatcher<MATCH> matcher;
  
  @Accessors(AccessorType.PROTECTED_SETTER)
  private MATCH filterMatch;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private QueryEvaluationHint hint;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private IQuerySpecificationRegistryEntry entry;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private RuleSpecification<MATCH> ruleSpec;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private Exception exception;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private int matchCount;
  
  @Override
  public MATCH getFilterMatch() {
    if ((this.filterMatch == null)) {
      this.filterMatch = this.matcher.newEmptyMatch();
    }
    return this.filterMatch;
  }
  
  public void resetFilter() {
    this.filterMatch = this.matcher.newEmptyMatch();
    this.filterUpdated(this.filterMatch);
  }
  
  public void filterUpdated(final MATCH filterMatch) {
    if ((filterMatch != this.filterMatch)) {
      this.filterMatch = filterMatch;
    }
    this.parent.matcherFilterUpdated(this);
  }
  
  public boolean isFiltered() {
    final Function1<Object, Boolean> _function = (Object it) -> {
      return Boolean.valueOf((it != null));
    };
    return IterableExtensions.<Object>exists(((Iterable<Object>)Conversions.doWrapArray(this.getFilterMatch().toArray())), _function);
  }
  
  public QueryResultTreeMatcher<?> remove() {
    return this.parent.removeMatcher(this);
  }
  
  @Pure
  public QueryResultTreeInput getParent() {
    return this.parent;
  }
  
  @Pure
  public ViatraQueryMatcher<MATCH> getMatcher() {
    return this.matcher;
  }
  
  protected void setFilterMatch(final MATCH filterMatch) {
    this.filterMatch = filterMatch;
  }
  
  @Pure
  public QueryEvaluationHint getHint() {
    return this.hint;
  }
  
  protected void setHint(final QueryEvaluationHint hint) {
    this.hint = hint;
  }
  
  @Pure
  public IQuerySpecificationRegistryEntry getEntry() {
    return this.entry;
  }
  
  protected void setEntry(final IQuerySpecificationRegistryEntry entry) {
    this.entry = entry;
  }
  
  @Pure
  public RuleSpecification<MATCH> getRuleSpec() {
    return this.ruleSpec;
  }
  
  protected void setRuleSpec(final RuleSpecification<MATCH> ruleSpec) {
    this.ruleSpec = ruleSpec;
  }
  
  @Pure
  public Exception getException() {
    return this.exception;
  }
  
  protected void setException(final Exception exception) {
    this.exception = exception;
  }
  
  @Pure
  public int getMatchCount() {
    return this.matchCount;
  }
  
  protected void setMatchCount(final int matchCount) {
    this.matchCount = matchCount;
  }
  
  public QueryResultTreeMatcher(final QueryResultTreeInput parent, final ViatraQueryMatcher<MATCH> matcher) {
    super();
    this.parent = parent;
    this.matcher = matcher;
  }
}
