/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.oauth;

import java.net.URI;
import org.apache.http.client.fluent.Executor;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.oauth.OAuthSession;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.oauth.OAuthParameters;
import org.eclipse.userstorage.spi.AbstractCredentialsProvider;

public abstract class OAuthCredentialsProvider
extends AbstractCredentialsProvider {
    protected final Executor executor = this.createExecutor();
    private final String clientId;
    private final byte[] encipheredClientSecret;
    private final String[] scopes;
    private final URI callback;
    private final URI authServiceBaseURI;
    protected String stateCode;

    protected OAuthCredentialsProvider(URI authService, String clientId, String clientSecret, String[] scopes, URI expectedCallback) {
        this.authServiceBaseURI = authService;
        this.clientId = clientId;
        this.encipheredClientSecret = StringUtil.encrypt((String)clientSecret);
        this.scopes = scopes;
        this.callback = expectedCallback;
        this.stateCode = Double.toString(Math.random());
    }

    protected OAuthCredentialsProvider(OAuthParameters parameters) {
        this(parameters.getService(), parameters.getDecryptedClientID(), parameters.getDecryptedClientSecret(), parameters.getScopes(), parameters.getExpectedCallback());
    }

    protected Executor createExecutor() {
        return Executor.newInstance();
    }

    protected URI getAuthorizationServiceBaseURI(IStorageService service) {
        return this.authServiceBaseURI == null ? service.getServiceURI() : this.authServiceBaseURI;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected String getClientSecret() {
        return StringUtil.decrypt((byte[])this.encipheredClientSecret);
    }

    protected char[] getClientSecretAsChars() {
        return StringUtil.decryptAsChars((byte[])this.encipheredClientSecret);
    }

    protected String[] getScopes() {
        return this.scopes;
    }

    protected URI getRegisteredCallback() {
        return this.callback;
    }

    public Session openSession(IStorageService service) {
        return new OAuthSession(service, this);
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }
}

