/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.urischeme.IUriSchemeExtensionReader;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.eclipse.urischeme.IUriSchemeProcessor;

public class UriSchemeProcessor
implements IUriSchemeProcessor {
    private Map<String, IUriSchemeHandler> createdHandlers = new HashMap<String, IUriSchemeHandler>();
    IUriSchemeExtensionReader reader = IUriSchemeExtensionReader.newInstance();

    @Override
    public void handleUri(String uriScheme, String uri) throws CoreException {
        IUriSchemeHandler handler = null;
        handler = this.getHandler(uriScheme);
        if (handler != null) {
            handler.handle(uri);
        }
    }

    private IUriSchemeHandler getHandler(String uriScheme) throws CoreException {
        IUriSchemeHandler handler;
        if (this.createdHandlers.containsKey(uriScheme)) {
            handler = this.createdHandlers.get(uriScheme);
        } else {
            handler = this.reader.getHandlerFromExtensionPoint(uriScheme);
            this.createdHandlers.put(uriScheme, handler);
        }
        return handler;
    }

    @Override
    public boolean canHandle(URI uri) {
        try {
            return this.getHandler(uri.getScheme()) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

