/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.internal.operations.BehavioredClassifierOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseCaseOperations
extends BehavioredClassifierOperations {
    protected UseCaseOperations() {
    }

    public static boolean validateMustHaveName(UseCase useCase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (UseCaseOperations.isEmpty((String)useCase.getName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 156, UMLPlugin.INSTANCE.getString("_UI_UseCase_MustHaveName_diagnostic", UseCaseOperations.getMessageSubstitutions(context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateBinaryAssociations(UseCase useCase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (Association association : useCase.getAssociations()) {
            if (association.isBinary()) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 153, UMLPlugin.INSTANCE.getString("_UI_UseCase_BinaryAssociations_diagnostic", UseCaseOperations.getMessageSubstitutions(context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoAssociationToUseCase(UseCase useCase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (Association association : useCase.getAssociations()) {
            EList<Type> endTypes = association.getEndTypes();
            if (endTypes.size() != 2) continue;
            Type end1 = (Type)endTypes.get(0);
            Type end2 = (Type)endTypes.get(1);
            if (!(end1 instanceof UseCase) || !(end2 instanceof UseCase)) continue;
            UseCase useCase1 = (UseCase)end1;
            UseCase useCase2 = (UseCase)end2;
            UniqueEList.FastCompare subjects = new UniqueEList.FastCompare(useCase1.getSubjects());
            subjects.retainAll(useCase2.getSubjects());
            if (subjects.isEmpty()) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 154, UMLPlugin.INSTANCE.getString("_UI_UseCase_NoAssociationToUseCase_diagnostic", UseCaseOperations.getMessageSubstitutions(context, (Object)useCase1, (Object)useCase2)), new Object[]{useCase1, useCase2}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateCannotIncludeSelf(UseCase useCase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (useCase.allIncludedUseCases().contains((Object)useCase)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 155, UMLPlugin.INSTANCE.getString("_UI_UseCase_CannotIncludeSelf_diagnostic", UseCaseOperations.getMessageSubstitutions(context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    protected static EList<UseCase> allIncludedUseCases(UseCase useCase, EList<UseCase> allIncludedUseCases) {
        for (Include include : useCase.getIncludes()) {
            UseCase addition = include.getAddition();
            if (addition == null || !allIncludedUseCases.add((Object)addition)) continue;
            UseCaseOperations.allIncludedUseCases(addition, allIncludedUseCases);
        }
        return allIncludedUseCases;
    }

    public static EList<UseCase> allIncludedUseCases(UseCase useCase) {
        return ECollections.unmodifiableEList(UseCaseOperations.allIncludedUseCases(useCase, (EList<UseCase>)new UniqueEList.FastCompare()));
    }
}

