/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.tree;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;

public final class TreeUtil {
    private TreeUtil() {
    }

    public static ISelection getNewSelection(ISelection selection, @NonNull ITmfTreeViewerEntry rootEntry) {
        StructuredSelection structuredSelection;
        Object element;
        if (selection instanceof StructuredSelection && !selection.isEmpty() && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITmfTreeViewerEntry) {
            ITmfTreeViewerEntry newSelection = TreeUtil.findEquivalent(rootEntry, (ITmfTreeViewerEntry)element);
            return newSelection != null ? new StructuredSelection((Object)newSelection) : StructuredSelection.EMPTY;
        }
        return selection;
    }

    public static void add(Collection<String> collection, @NonNull ITmfTreeViewerEntry entry) {
        collection.add(TreeUtil.getPath(entry).toString());
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : entry.getChildren()) {
            TreeUtil.add(collection, iTmfTreeViewerEntry);
        }
    }

    public static void addIf(Collection<@NonNull ITmfTreeViewerEntry> toAdd, @NonNull ITmfTreeViewerEntry parent, Predicate<@NonNull ITmfTreeViewerEntry> condition) {
        if (condition.test(parent)) {
            toAdd.add(parent);
        }
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : parent.getChildren()) {
            TreeUtil.addIf(toAdd, iTmfTreeViewerEntry, condition);
        }
    }

    public static Collection<String> getPath(@NonNull ITmfTreeViewerEntry entry) {
        ArrayDeque<String> retVal = new ArrayDeque<String>();
        ITmfTreeViewerEntry current = entry;
        while (current.getParent() != null) {
            retVal.addFirst(current.getName());
            current = current.getParent();
        }
        return retVal;
    }

    private static @Nullable ITmfTreeViewerEntry findEquivalent(@NonNull ITmfTreeViewerEntry entriesToSearch, @NonNull ITmfTreeViewerEntry selectedItem) {
        Collection<String> path = TreeUtil.getPath(selectedItem);
        Iterator<String> iter = path.iterator();
        ITmfTreeViewerEntry currentEntry = entriesToSearch;
        while (iter.hasNext()) {
            String current = iter.next();
            boolean found = false;
            for (ITmfTreeViewerEntry iTmfTreeViewerEntry : currentEntry.getChildren()) {
                if (!Objects.equals(iTmfTreeViewerEntry.getName(), current)) continue;
                found = true;
                currentEntry = iTmfTreeViewerEntry;
                break;
            }
            if (found) continue;
            return null;
        }
        return currentEntry;
    }
}

