/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageExperimentElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class TracePackageImportOperation
extends AbstractTracePackageOperation
implements IOverwriteQuery {
    private final TracePackageElement[] fImportTraceElements;
    private final TmfTraceFolder fTmfTraceFolder;
    private final @NonNull TmfExperimentFolder fTmfExperimentFolder;

    public TracePackageImportOperation(String fileName, TracePackageElement[] importTraceElements, TmfTraceFolder tmfTraceFolder) {
        super(fileName);
        this.fImportTraceElements = importTraceElements;
        this.fTmfTraceFolder = tmfTraceFolder;
        this.fTmfExperimentFolder = (TmfExperimentFolder)NonNullUtils.checkNotNull((Object)tmfTraceFolder.getProject().getExperimentsFolder());
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        int totalWork = this.getNbCheckedElements(this.fImportTraceElements) * 2;
        progressMonitor.beginTask(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ImportingPackage, totalWork);
        this.doRun(progressMonitor);
        progressMonitor.done();
    }

    private void doRun(IProgressMonitor progressMonitor) {
        try {
            this.setStatus(this.deleteExistingTraces(progressMonitor));
            if (!this.getStatus().isOK()) {
                return;
            }
            ArrayList<TracePackageExperimentElement> experimentPackageElements = new ArrayList<TracePackageExperimentElement>();
            TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
            int n = this.fImportTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement packageElement = tracePackageElementArray[n2];
                TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
                if (TracePackageImportOperation.isFilesChecked(packageElement)) {
                    if (packageElement instanceof TracePackageExperimentElement) {
                        experimentPackageElements.add((TracePackageExperimentElement)packageElement);
                    } else {
                        TracePackageElement[] children;
                        TracePackageElement[] tracePackageElementArray2 = children = traceElement.getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TracePackageElement element = tracePackageElementArray2[n4];
                            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                            if (element instanceof TracePackageFilesElement) {
                                TracePackageFilesElement traceFilesElement = (TracePackageFilesElement)element;
                                this.setStatus(this.importTraceFiles(traceFilesElement, traceElement, progressMonitor));
                            }
                            if (!this.getStatus().isOK()) {
                                return;
                            }
                            ++n4;
                        }
                        this.setStatus(this.importSupplFiles(traceElement, progressMonitor));
                        if (!this.getStatus().isOK()) {
                            return;
                        }
                    }
                }
                ++n2;
            }
            for (TracePackageExperimentElement experimentPackageElement : experimentPackageElements) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                this.importExperiment(experimentPackageElement, progressMonitor);
                if (this.getStatus().isOK()) continue;
                return;
            }
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
            Thread.currentThread().interrupt();
        }
    }

    public static boolean isFilesChecked(TracePackageElement tracePackageElement) {
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                return element.isChecked();
            }
            ++n2;
        }
        return false;
    }

    private TmfCommonProjectElement getMatchingProjectElement(TracePackageTraceElement tracePackageElement) {
        if (tracePackageElement instanceof TracePackageExperimentElement) {
            for (TmfExperimentElement experiment : this.fTmfExperimentFolder.getExperiments()) {
                if (!experiment.getName().equals(tracePackageElement.getImportName())) continue;
                return experiment;
            }
        } else {
            IPath tracePath = this.fTmfTraceFolder.getPath().append(tracePackageElement.getDestinationElementPath());
            List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
            for (TmfTraceElement t : traces) {
                if (!t.getPath().equals((Object)tracePath)) continue;
                return t;
            }
        }
        return null;
    }

    private IStatus deleteExistingTraces(IProgressMonitor progressMonitor) {
        TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
        int n = this.fImportTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement packageElement = tracePackageElementArray[n2];
            TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
            if (TracePackageImportOperation.isFilesChecked(traceElement)) {
                TmfCommonProjectElement projectElement = this.getMatchingProjectElement(traceElement);
                try {
                    if (projectElement instanceof TmfExperimentElement) {
                        Display.getDefault().syncExec(() -> projectElement.closeEditors());
                        projectElement.deleteSupplementaryFolder();
                        projectElement.getResource().delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor));
                    } else if (projectElement instanceof TmfTraceElement) {
                        ((TmfTraceElement)projectElement).delete((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor), true);
                    }
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void importBookmarks(IResource traceRes, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        TracePackageElement[] tracePackageElementArray = traceElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement o = tracePackageElementArray[n2];
            if (o instanceof TracePackageBookmarkElement && o.isChecked()) {
                IFile bookmarksFile = null;
                TmfCommonProjectElement projectElement = this.getMatchingProjectElement(traceElement);
                if (projectElement != null) {
                    try {
                        bookmarksFile = projectElement.createBookmarksFile(monitor);
                        String traceEditorId = projectElement.getEditorId();
                        String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                        IDE.setDefaultEditor((IFile)bookmarksFile, (String)editorId);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmarkFile, traceRes.getName()), e);
                    }
                }
                if (bookmarksFile == null) break;
                TracePackageBookmarkElement bookmarkElement = (TracePackageBookmarkElement)o;
                List<Map<String, String>> bookmarks = bookmarkElement.getBookmarks();
                for (Map<String, String> attrs : bookmarks) {
                    IMarker createMarker = null;
                    try {
                        createMarker = bookmarksFile.createMarker("org.eclipse.core.resources.bookmark");
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                    if (createMarker == null || !createMarker.exists()) continue;
                    try {
                        for (Map.Entry<String, String> entry : attrs.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            if (key.equals("location")) {
                                try {
                                    createMarker.setAttribute("location", Integer.parseInt(value));
                                }
                                catch (NumberFormatException e) {
                                    createMarker.setAttribute("location", (Object)value);
                                }
                                continue;
                            }
                            createMarker.setAttribute(key, (Object)value);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                }
            }
            ++n2;
        }
        monitor.worked(1);
    }

    private IStatus importTraceFiles(TracePackageFilesElement traceFilesElement, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        ArrayList<Pair<String, String>> fileNameAndLabelPairs = new ArrayList<Pair<String, String>>();
        String sourceName = (String)NonNullUtils.checkNotNull((Object)traceFilesElement.getFileName());
        String destinationName = (String)NonNullUtils.checkNotNull((Object)traceElement.getImportName());
        fileNameAndLabelPairs.add(new Pair((Object)sourceName, (Object)destinationName));
        IPath containerPath = this.fTmfTraceFolder.getPath();
        IStatus status = this.importFiles(this.getSpecifiedArchiveFile(), fileNameAndLabelPairs, containerPath, (IPath)Path.EMPTY, Collections.emptyMap(), monitor);
        if (!this.getStatus().isOK()) {
            return status;
        }
        IResource traceRes = this.fTmfTraceFolder.getResource().findMember(traceElement.getDestinationElementPath());
        if (traceRes == null || !traceRes.exists()) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorFindingImportedTrace, destinationName));
        }
        TraceTypeHelper traceType = null;
        String traceTypeStr = traceElement.getTraceType();
        if (traceTypeStr != null) {
            traceType = TmfTraceType.getTraceType((String)traceTypeStr);
            if (traceType == null) {
                return new Status(4, "org.eclipse.tracecompass.tmf.ui", MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), destinationName));
            }
        } else {
            try {
                monitor.subTask(MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_DetectingTraceType, destinationName));
                traceType = TmfTraceTypeUIUtils.selectTraceType(traceRes.getLocation().toOSString(), null, null);
            }
            catch (TmfTraceImportException tmfTraceImportException) {
                // empty catch block
            }
        }
        if (traceType != null) {
            try {
                TmfTraceTypeUIUtils.setTraceType(traceRes, traceType);
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.tracecompass.tmf.ui", MessageFormat.format(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), destinationName), (Throwable)e);
            }
        }
        this.importBookmarks(traceRes, traceElement, monitor);
        try {
            URI uri = new File(this.getFileName()).toURI();
            Path entryPath = new Path(traceFilesElement.getFileName());
            if (traceRes instanceof IFolder) {
                entryPath = entryPath.addTrailingSeparator();
            }
            String sourceLocation = URIUtil.toUnencodedString((URI)URIUtil.toJarURI((URI)uri, (IPath)entryPath));
            traceRes.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return status;
    }

    private IStatus importSupplFiles(TracePackageTraceElement packageElement, IProgressMonitor monitor) {
        TmfCommonProjectElement projectElement;
        ArrayList<Pair<String, String>> fileNameAndLabelPairs = new ArrayList<Pair<String, String>>();
        HashMap<String, String> suppFilesRename = new HashMap<String, String>();
        TracePackageElement[] tracePackageElementArray = packageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageSupplFilesElement) {
                TracePackageElement[] tracePackageElementArray2 = element.getChildren();
                int n3 = tracePackageElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TracePackageElement child = tracePackageElementArray2[n4];
                    if (child.isChecked()) {
                        TracePackageSupplFileElement supplFile = (TracePackageSupplFileElement)child;
                        if (packageElement instanceof TracePackageExperimentElement) {
                            String oldExpName = TracePackageImportOperation.getOldExpName(supplFile);
                            if (!packageElement.getImportName().equals(oldExpName)) {
                                suppFilesRename.put(supplFile.getText(), supplFile.getText().replace(oldExpName, packageElement.getImportName()));
                            }
                        }
                        fileNameAndLabelPairs.add((Pair<String, String>)new Pair((Object)((String)NonNullUtils.checkNotNull((Object)supplFile.getText())), (Object)((String)NonNullUtils.checkNotNull((Object)new Path(supplFile.getText()).lastSegment()))));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!fileNameAndLabelPairs.isEmpty() && (projectElement = this.getMatchingProjectElement(packageElement)) != null) {
            IPath destinationContainerPath;
            AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
            projectElement.refreshSupplementaryFolder();
            if (packageElement instanceof TracePackageExperimentElement) {
                destinationContainerPath = projectElement.getProject().getSupplementaryFolder().getFullPath();
            } else {
                TmfTraceFolder tracesFolder = this.fTmfTraceFolder.getProject().getTracesFolder();
                if (tracesFolder == null) {
                    return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TracePackage_ErrorOperation);
                }
                IPath traceFolderRelativePath = this.fTmfTraceFolder.getPath().makeRelativeTo(tracesFolder.getPath());
                IFolder traceSupplementaryFolder = this.fTmfTraceFolder.getTraceSupplementaryFolder(traceFolderRelativePath.toString());
                destinationContainerPath = traceSupplementaryFolder.getFullPath();
            }
            Path baseSourcePath = new Path(".tracing");
            return this.importFiles(archiveFile, fileNameAndLabelPairs, destinationContainerPath, (IPath)baseSourcePath, suppFilesRename, monitor);
        }
        return Status.OK_STATUS;
    }

    private static String getOldExpName(TracePackageSupplFileElement supplFile) {
        String[] split = supplFile.getText().split("/");
        String oldExpName = null;
        int i = 0;
        while (i < split.length) {
            if (split[i].equals(".tracing")) {
                oldExpName = split[i + 1];
                oldExpName = oldExpName.substring(0, oldExpName.length() - 4);
            }
            ++i;
        }
        return oldExpName;
    }

    private IStatus importFiles(AbstractTracePackageOperation.ArchiveFile archiveFile, List<Pair<String, String>> fileNameAndLabelPairs, IPath destinationContainerPath, IPath baseSourcePath, @NonNull Map<String, String> filesRenameMap, IProgressMonitor monitor) {
        ArrayList<ArchiveProviderElement> objects = new ArrayList<ArchiveProviderElement>();
        Enumeration<@NonNull ? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
        block3: while (entries.hasMoreElements()) {
            AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path fullArchivePath = new Path(entryName);
            if (fullArchivePath.hasTrailingSeparator()) continue;
            for (Pair<String, String> fileNameAndLabel : fileNameAndLabelPairs) {
                Path searchedArchivePath = new Path((String)fileNameAndLabel.getFirst());
                boolean fileMatch = entryName.equalsIgnoreCase(searchedArchivePath.toString());
                boolean folderMatch = entryName.startsWith(searchedArchivePath + "/");
                if (!fileMatch && !folderMatch) continue;
                String newFilePath = filesRenameMap.get(entryName);
                if (newFilePath != null) {
                    fullArchivePath = new Path(newFilePath);
                }
                IPath destinationPath = fullArchivePath.makeRelativeTo(baseSourcePath);
                String resourceLabel = folderMatch ? fullArchivePath.lastSegment() : (String)fileNameAndLabel.getSecond();
                ArchiveProviderElement pe = new ArchiveProviderElement(destinationPath.toString(), resourceLabel, archiveFile, entry);
                objects.add(pe);
                continue block3;
            }
        }
        ImportProvider provider = new ImportProvider();
        ImportOperation operation = new ImportOperation(destinationContainerPath, null, (IImportStructureProvider)provider, (IOverwriteQuery)this, objects);
        operation.setCreateContainerStructure(true);
        operation.setOverwriteResources(true);
        try {
            operation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            archiveFile.close();
        }
        catch (IOException | InvocationTargetException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Status.CANCEL_STATUS;
        }
        if (provider.getException() != null) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)provider.getException());
        }
        return operation.getStatus();
    }

    private void importExperiment(TracePackageExperimentElement experimentPackageElement, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
        String name = (String)NonNullUtils.checkNotNull((Object)experimentPackageElement.getImportName());
        String experimentType = experimentPackageElement.getTraceType();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        List<TmfTraceElement> traceElements = this.fTmfTraceFolder.getTraces();
        boolean allFound = true;
        for (String expTrace : experimentPackageElement.getExpTraces()) {
            boolean found = false;
            for (TmfTraceElement traceElement : traceElements) {
                if (!traceElement.getPath().makeRelativeTo(this.fTmfTraceFolder.getPath()).toString().equals(expTrace)) continue;
                traces.add(traceElement);
                found = true;
                break;
            }
            allFound &= found;
        }
        NewExperimentOperation newExperimentOperation = new NewExperimentOperation(this.fTmfExperimentFolder, name, experimentType, traces);
        newExperimentOperation.run((IProgressMonitor)subMonitor.split(1));
        this.setStatus(newExperimentOperation.getStatus());
        if (!this.getStatus().isOK()) {
            return;
        }
        if (allFound) {
            this.importBookmarks((IResource)newExperimentOperation.getExperimentFolder(), experimentPackageElement, (IProgressMonitor)subMonitor.split(1));
            this.setStatus(this.importSupplFiles(experimentPackageElement, (IProgressMonitor)subMonitor.split(1)));
        }
    }

    public String queryOverwrite(String pathString) {
        return "ALL";
    }

    private class ArchiveProviderElement {
        private final String fPath;
        private final String fLabel;
        private AbstractTracePackageOperation.ArchiveFile fArchiveFile;
        private AbstractTracePackageOperation.ArchiveEntry fEntry;

        public ArchiveProviderElement(String destinationPath, String label, AbstractTracePackageOperation.ArchiveFile archiveFile, AbstractTracePackageOperation.ArchiveEntry entry) {
            this.fPath = destinationPath;
            this.fLabel = label;
            this.fArchiveFile = archiveFile;
            this.fEntry = entry;
        }

        public InputStream getContents() throws IOException {
            return this.fArchiveFile.getInputStream(this.fEntry);
        }

        public String getFullPath() {
            return this.fPath;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public boolean isFolder() {
            return false;
        }
    }

    private class ImportProvider
    implements IImportStructureProvider {
        private Exception fException;

        private ImportProvider() {
        }

        public List getChildren(Object element) {
            return null;
        }

        public InputStream getContents(Object element) {
            InputStream inputStream = null;
            try {
                inputStream = ((ArchiveProviderElement)element).getContents();
            }
            catch (IOException e) {
                this.fException = e;
            }
            return inputStream;
        }

        public String getFullPath(Object element) {
            return ((ArchiveProviderElement)element).getFullPath();
        }

        public String getLabel(Object element) {
            return ((ArchiveProviderElement)element).getLabel();
        }

        public boolean isFolder(Object element) {
            return ((ArchiveProviderElement)element).isFolder();
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

