/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.classic;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.classic.ClassicNode;

public class ClassicHistoryTree<E extends IHTInterval>
extends AbstractHistoryTree<E, ClassicNode<E>> {
    public static final int HISTORY_FILE_MAGIC_NUMBER = 100641024;
    private static final int FILE_VERSION = 8;

    public ClassicHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart, IHTIntervalReader<E> intervalReader) throws IOException {
        super(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart, intervalReader);
    }

    public ClassicHistoryTree(File existingStateFile, int expProviderVersion, IHTIntervalReader<E> intervalReader) throws IOException {
        super(existingStateFile, expProviderVersion, intervalReader);
    }

    @Override
    protected int getMagicNumber() {
        return 100641024;
    }

    @Override
    protected int getFileVersion() {
        return 8;
    }

    @Override
    protected AbstractHistoryTree.IHTNodeFactory<E, ClassicNode<E>> getNodeFactory() {
        return (t, b, m, seq, p, start) -> new ClassicNode(t, b, m, seq, p, start);
    }

    @Override
    protected long getNewBranchStart(int depth, E interval) {
        return this.getTreeEnd() + 1L;
    }

    @Override
    @VisibleForTesting
    protected boolean verifyChildrenSpecific(ClassicNode<E> parent, int index, ClassicNode<E> child) {
        return parent.getChildStart(index) == child.getNodeStart();
    }

    @Override
    @VisibleForTesting
    protected boolean verifyIntersectingChildren(ClassicNode<E> parent, ClassicNode<E> child) {
        int childSequence = child.getSequenceNumber();
        long t = parent.getNodeStart();
        while (t < parent.getNodeEnd()) {
            TimeRangeCondition timeCondition = TimeRangeCondition.singleton(t);
            boolean shouldBeInCollection = timeCondition.intersects(child.getNodeStart(), child.getNodeEnd());
            Collection<Integer> nextChildren = parent.selectNextChildren(timeCondition);
            if (nextChildren.size() != 1 || shouldBeInCollection != nextChildren.contains(childSequence)) {
                return false;
            }
            ++t;
        }
        return true;
    }
}

