/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;

public class LamiGenericAspect
extends LamiTableEntryAspect {
    private final int fColIndex;
    private final boolean fIsContinuous;
    private final boolean fIsTimeStamp;

    public LamiGenericAspect(String aspectName, @Nullable String units, int colIndex, boolean isContinuous, boolean isTimeStamp) {
        super(aspectName, units);
        this.fColIndex = colIndex;
        this.fIsContinuous = isContinuous;
        this.fIsTimeStamp = isTimeStamp;
    }

    @Override
    public boolean isContinuous() {
        return this.fIsContinuous;
    }

    @Override
    public boolean isTimeStamp() {
        return this.fIsTimeStamp;
    }

    @Override
    public @Nullable String resolveString(@NonNull LamiTableEntry entry) {
        return entry.getValue(this.fColIndex).toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        if (this.fIsContinuous) {
            try {
                LamiData value = entry.getValue(this.fColIndex);
                if (value.toString() != null) {
                    return Double.parseDouble(value.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected int getColIndex() {
        return this.fColIndex;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        if (this.isContinuous()) {
            return LamiComparators.getDoubleComparator(this::resolveNumber);
        }
        return LamiComparators.getStringComparator(this::resolveString);
    }
}

