/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.tcf.core.va.interfaces.IValueAdd;
import org.eclipse.tcf.te.tcf.core.va.internal.Binding;
import org.eclipse.tcf.te.tcf.core.va.internal.BindingExtensionPointManager;

public class ValueAddManager
extends AbstractExtensionPointManager<IValueAdd> {
    ValueAddManager() {
    }

    public static ValueAddManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.tcf.core.valueadds";
    }

    protected String getConfigurationElementName() {
        return "valueadd";
    }

    public IValueAdd[] getValueAdds(boolean unique) {
        ArrayList<IValueAdd> contributions = new ArrayList<IValueAdd>();
        Collection valueAdds = this.getExtensions().values();
        for (ExecutableExtensionProxy valueAdd : valueAdds) {
            IValueAdd instance;
            IValueAdd iValueAdd = instance = unique ? (IValueAdd)valueAdd.newInstance() : (IValueAdd)valueAdd.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new IValueAdd[contributions.size()]);
    }

    public IValueAdd getValueAdd(String id, boolean unique) {
        IValueAdd contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = unique ? (IValueAdd)proxy.newInstance() : (IValueAdd)proxy.getInstance();
        }
        return contribution;
    }

    public IValueAdd[] getValueAdd(IPeer peer) {
        Binding[] bindings;
        Assert.isNotNull((Object)peer);
        ArrayList<IValueAdd> valueAdds = new ArrayList<IValueAdd>();
        Binding[] bindingArray = bindings = BindingExtensionPointManager.getInstance().getApplicableBindings(peer);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            IValueAdd valueAdd = this.getValueAdd(binding.getValueAddId(), false);
            if (valueAdd != null && !valueAdds.contains(valueAdd)) {
                valueAdds.add(valueAdd);
            }
            ++n2;
        }
        return valueAdds.toArray(new IValueAdd[valueAdds.size()]);
    }

    private static class LazyInstance {
        public static ValueAddManager instance = new ValueAddManager();

        private LazyInstance() {
        }
    }
}

