/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.model;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;

public class ElfLoader
implements Runnable {
    private final IChannel channel;
    private Map<String, Object> args;
    private boolean download;
    private boolean set_pc;
    private Runnable done;
    private final IRunControl service_rc;
    private final IMemory service_mem;
    private final IRegisters service_regs;
    private final Set<IToken> cmds = new HashSet<IToken>();
    private final Map<String, IRunControl.RunControlContext> contexts = new HashMap<String, IRunControl.RunControlContext>();
    private final Set<String> running = new HashSet<String>();
    private List<Throwable> errors = new ArrayList<Throwable>();
    private final IRunControl.RunControlListener rc_listener = new IRunControl.RunControlListener(){

        public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
            ElfLoader.this.running.remove(id);
            ElfLoader.this.run();
        }

        public void contextResumed(String id) {
            ElfLoader.this.running.add(id);
            ElfLoader.this.run();
        }

        public void contextRemoved(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ElfLoader.this.contexts.remove(id);
                ElfLoader.this.running.remove(id);
                ++n2;
            }
            ElfLoader.this.run();
        }

        public void contextException(String context, String msg) {
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextAdded(IRunControl.RunControlContext[] arr) {
            IRunControl.RunControlContext[] runControlContextArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                String id = ctx.getID();
                ElfLoader.this.contexts.put(id, ctx);
                if (ctx.hasState()) {
                    ElfLoader.this.running.add(id);
                }
                ++n2;
            }
            ElfLoader.this.run();
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            String[] stringArray = suspended_ids;
            int n = suspended_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ElfLoader.this.running.remove(id);
                ++n2;
            }
            ElfLoader.this.run();
        }

        public void containerResumed(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ElfLoader.this.running.add(id);
                ++n2;
            }
            ElfLoader.this.run();
        }
    };
    private final IRunControl.DoneGetContext done_ctx_get_context = new IRunControl.DoneGetContext(){

        public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
            ElfLoader.this.cmds.remove(token);
            if (error != null) {
                ElfLoader.this.errors.add(error);
            } else {
                final String id = context.getID();
                ElfLoader.this.contexts.put(id, context);
                if (context.hasState()) {
                    ElfLoader.this.cmds.add(context.getState(new IRunControl.DoneGetState(){

                        public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                            ElfLoader.this.cmds.remove(token);
                            if (error != null) {
                                ElfLoader.this.errors.add(error);
                            } else if (!suspended) {
                                ElfLoader.this.running.add(id);
                            }
                            ElfLoader.this.run();
                        }
                    }));
                }
            }
            ElfLoader.this.run();
        }
    };
    private final IRunControl.DoneGetChildren done_ctx_get_children = new IRunControl.DoneGetChildren(){

        public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
            ElfLoader.this.cmds.remove(token);
            if (error != null) {
                ElfLoader.this.errors.add(error);
            } else if (context_ids != null) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    ElfLoader.this.cmds.add(ElfLoader.this.service_rc.getContext(id, ElfLoader.this.done_ctx_get_context));
                    ElfLoader.this.cmds.add(ElfLoader.this.service_rc.getChildren(id, (IRunControl.DoneGetChildren)this));
                    ++n2;
                }
            }
            ElfLoader.this.run();
        }
    };
    private final IMemory.DoneGetContext done_mem_get_context = new IMemory.DoneGetContext(){

        public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
            ElfLoader.this.cmds.remove(token);
            if (error != null) {
                ElfLoader.this.errors.add(error);
            } else {
                if (!$assertionsDisabled && context == null) {
                    throw new AssertionError();
                }
                ElfLoader.this.mem_ctx = context;
                File fnm = null;
                try {
                    fnm = new File((String)ElfLoader.this.args.get("File"));
                    ElfLoader.this.file = new RandomAccessFile(fnm, "r");
                    try {
                        ElfLoader.this.downloadFile(context);
                    }
                    finally {
                        ElfLoader.this.file.close();
                    }
                }
                catch (Exception e) {
                    if (fnm != null) {
                        e = new Exception("Cannot read '" + fnm.getName() + "'", e);
                    }
                    ElfLoader.this.errors.add(e);
                }
                ElfLoader.this.file = null;
            }
            ElfLoader.this.run();
        }
    };
    private final IRegisters.DoneGetChildren done_regs_get_children = new IRegisters.DoneGetChildren(){

        public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
            ElfLoader.this.cmds.remove(token);
            if (error != null) {
                ElfLoader.this.errors.add(error);
            }
            if (context_ids != null) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    ElfLoader.this.cmds.add(ElfLoader.this.service_regs.getContext(id, new IRegisters.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                            ElfLoader.this.cmds.remove(token);
                            if (error != null) {
                                ElfLoader.this.errors.add(error);
                            }
                            if (context != null) {
                                if ("PC".equals(context.getRole())) {
                                    ElfLoader.this.reg_pc = context;
                                    ElfLoader.this.setEntryAddress();
                                } else if (ElfLoader.this.reg_pc == null && ElfLoader.this.errors.size() == 0) {
                                    ElfLoader.this.cmds.add(ElfLoader.this.service_regs.getChildren(context.getID(), ElfLoader.this.done_regs_get_children));
                                }
                            }
                            ElfLoader.this.run();
                        }
                    }));
                    ++n2;
                }
            }
            ElfLoader.this.run();
        }
    };
    private static final int PT_LOAD = 1;
    private boolean listener_ok;
    private boolean started_context_retrieval;
    private boolean started_reginfo_retrieval;
    private boolean disposed;
    private RandomAccessFile file;
    private boolean big_endian;
    private boolean elf64;
    private IMemory.MemoryContext mem_ctx;
    private BigInteger entry_addr;
    private IRegisters.RegistersContext reg_pc;
    private long start_time;

    ElfLoader(IChannel channel) {
        this.channel = channel;
        this.service_rc = (IRunControl)channel.getRemoteService(IRunControl.class);
        this.service_mem = (IMemory)channel.getRemoteService(IMemory.class);
        this.service_regs = (IRegisters)channel.getRemoteService(IRegisters.class);
    }

    void load(Map<String, Object> args, Runnable done) {
        this.args = args;
        this.done = done;
        Boolean b1 = (Boolean)args.get("Download");
        Boolean b2 = (Boolean)args.get("SetPC");
        this.download = b1 != null && b1 != false;
        this.set_pc = b2 != null && b2 != false;
        this.start_time = System.currentTimeMillis();
        this.started_reginfo_retrieval = false;
        this.entry_addr = null;
        this.mem_ctx = null;
        this.reg_pc = null;
        Protocol.invokeLater((Runnable)this);
    }

    void dispose() {
        if (this.service_rc != null) {
            this.service_rc.removeListener(this.rc_listener);
        }
        this.disposed = true;
    }

    private BigInteger readNumberX() throws IOException {
        int size = this.elf64 ? 8 : 4;
        byte[] buf = new byte[size + 1];
        this.file.readFully(buf, 1, size);
        if (!this.big_endian) {
            int i = 0;
            while (i < size / 2) {
                byte x = buf[i + 1];
                buf[i + 1] = buf[size - i];
                buf[size - i] = x;
                ++i;
            }
        }
        return new BigInteger(buf);
    }

    private int readInt2() throws IOException {
        int x = this.file.readUnsignedByte();
        int y = this.file.readUnsignedByte();
        return this.big_endian ? (x << 8) + y : x + (y << 8);
    }

    private int readInt4() throws IOException {
        int x = this.readInt2();
        int y = this.readInt2();
        return this.big_endian ? (x << 16) + y : x + (y << 16);
    }

    private void downloadFile(IMemory.MemoryContext context) throws Exception {
        if (this.file.readByte() != 127 || this.file.readByte() != 69 || this.file.readByte() != 76 || this.file.readByte() != 70) {
            throw new IOException("Not an ELF file");
        }
        switch (this.file.readByte()) {
            case 1: {
                this.elf64 = false;
                break;
            }
            case 2: {
                this.elf64 = true;
                break;
            }
            default: {
                throw new IOException("Invalid ELF file");
            }
        }
        switch (this.file.readByte()) {
            case 1: {
                this.big_endian = false;
                break;
            }
            case 2: {
                this.big_endian = true;
                break;
            }
            default: {
                throw new IOException("Invalid ELF file");
            }
        }
        this.file.seek(24L);
        this.entry_addr = this.readNumberX();
        if (this.download) {
            BigInteger phoff = this.readNumberX();
            this.readNumberX();
            this.file.seek(this.file.getFilePointer() + 6L);
            int phentsize = this.readInt2();
            int phnum = this.readInt2();
            int n = 0;
            while (n < phnum) {
                this.file.seek(phoff.longValue() + (long)(n * phentsize));
                int p_type = this.readInt4();
                if (p_type == 1) {
                    if (this.elf64) {
                        this.readInt4();
                    }
                    BigInteger p_offset = this.readNumberX();
                    this.readNumberX();
                    BigInteger p_paddr = this.readNumberX();
                    BigInteger p_filesz = this.readNumberX();
                    BigInteger p_memsz = this.readNumberX();
                    byte[] buf = new byte[p_filesz.intValue()];
                    this.file.seek(p_offset.longValue());
                    this.file.readFully(buf);
                    this.cmds.add(context.set((Number)p_paddr, 4, buf, 0, buf.length, 0, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            ElfLoader.this.cmds.remove(token);
                            if (error != null) {
                                ElfLoader.this.errors.add(error);
                            }
                            ElfLoader.this.run();
                        }
                    }));
                    BigInteger fill = p_memsz.subtract(p_filesz);
                    if (fill.compareTo(BigInteger.ZERO) > 0) {
                        buf = new byte[4];
                        this.cmds.add(context.fill((Number)p_paddr.add(p_filesz), 4, buf, fill.intValue(), 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                ElfLoader.this.cmds.remove(token);
                                if (error != null) {
                                    ElfLoader.this.errors.add(error);
                                }
                                ElfLoader.this.run();
                            }
                        }));
                    }
                }
                ++n;
            }
        }
    }

    private void setEntryAddress() {
        byte[] value = new byte[this.reg_pc.getSize()];
        boolean big_endian = this.reg_pc.isBigEndian();
        BigInteger n = this.entry_addr;
        int i = 0;
        while (i < value.length) {
            value[big_endian ? value.length - i - 1 : i] = n.byteValue();
            n = n.shiftRight(8);
            ++i;
        }
        this.cmds.add(this.reg_pc.set(value, new IRegisters.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                ElfLoader.this.cmds.remove(token);
                if (error != null) {
                    ElfLoader.this.errors.add(error);
                }
                ElfLoader.this.run();
            }
        }));
    }

    private String getFullName(IRunControl.RunControlContext ctx) {
        String parent;
        if (ctx == null) {
            return null;
        }
        String name = ctx.getName();
        if (name == null) {
            name = ctx.getID();
        }
        if ((parent = ctx.getParentID()) == null) {
            return "/" + name;
        }
        String path = this.getFullName(this.contexts.get(parent));
        if (path == null) {
            return null;
        }
        return String.valueOf(path) + '/' + name;
    }

    private boolean should_stop(String id) {
        String target_id = (String)this.args.get("ContextID");
        if (target_id == null) {
            return false;
        }
        IRunControl.RunControlContext ctx = this.contexts.get(id);
        if (ctx == null) {
            return false;
        }
        if (!ctx.hasState()) {
            return false;
        }
        if (id.equals(target_id)) {
            return true;
        }
        String group = ctx.getRCGroup();
        if (group == null) {
            return false;
        }
        IRunControl.RunControlContext target_ctx = this.contexts.get(target_id);
        if (target_ctx == null) {
            return false;
        }
        String target_group = target_ctx.getRCGroup();
        if (target_group == null) {
            return false;
        }
        return target_group.equals(group);
    }

    @Override
    public void run() {
        if (this.cmds.size() > 0) {
            return;
        }
        if (this.disposed) {
            return;
        }
        if (this.done == null) {
            return;
        }
        if (this.service_rc == null || this.service_mem == null) {
            this.errors.add(new Error("No services, cannot do anything"));
        }
        if (!this.listener_ok) {
            this.service_rc.addListener(this.rc_listener);
            this.listener_ok = true;
        }
        if (this.errors.size() == 0 && !this.started_context_retrieval) {
            this.cmds.add(this.service_rc.getChildren(null, this.done_ctx_get_children));
            this.started_context_retrieval = true;
            return;
        }
        if (this.errors.size() == 0 && this.running.size() > 0) {
            for (final String id : this.running) {
                if (!this.should_stop(id)) continue;
                if (System.currentTimeMillis() - this.start_time < 5000L) {
                    this.cmds.add(this.contexts.get(id).suspend(new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            ElfLoader.this.cmds.remove(token);
                            if (error != null && ElfLoader.this.running.contains(id)) {
                                ElfLoader.this.errors.add(error);
                            }
                            ElfLoader.this.run();
                        }
                    }));
                    continue;
                }
                String name = this.contexts.get(id).getName();
                if (name == null) {
                    name = id;
                }
                this.errors.add(new Exception("Cannot stop " + name));
            }
            if (this.cmds.size() > 0) {
                return;
            }
        }
        if (this.errors.size() == 0 && this.mem_ctx == null) {
            String id;
            id = (String)this.args.get("ContextID");
            if (id != null && this.contexts.get(id) != null) {
                this.cmds.add(this.service_mem.getContext(id, this.done_mem_get_context));
                return;
            }
            String name = (String)this.args.get("Context");
            if (name != null) {
                for (IRunControl.RunControlContext ctx : this.contexts.values()) {
                    if (!name.equals(this.getFullName(ctx))) continue;
                    this.cmds.add(this.service_mem.getContext(ctx.getID(), this.done_mem_get_context));
                    return;
                }
            }
            if (System.currentTimeMillis() - this.start_time < 5000L) {
                Protocol.invokeLater((long)200L, (Runnable)this);
                return;
            }
            this.errors.add(new Exception("Context not found: " + (name != null ? name : id)));
        }
        if (this.errors.size() == 0 && this.mem_ctx != null && this.entry_addr != null && this.set_pc && !this.started_reginfo_retrieval && this.service_regs != null) {
            this.started_reginfo_retrieval = true;
            this.cmds.add(this.service_regs.getChildren(this.mem_ctx.getID(), this.done_regs_get_children));
            return;
        }
        if (this.errors.size() > 0) {
            this.channel.terminate((Throwable)new Exception("Download error", this.errors.get(0)));
        }
        Protocol.invokeLater((Runnable)this.done);
        this.done = null;
    }
}

