/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;

class TCFChildrenHoverExpressions
extends TCFChildren {
    private String expression;

    TCFChildrenHoverExpressions(TCFNode parent) {
        super(parent, 16);
    }

    void setExpression(String expression) {
        if (expression == this.expression) {
            return;
        }
        if (expression != null && expression.equals(this.expression)) {
            return;
        }
        this.expression = expression;
        this.cancel();
    }

    void onSuspended(boolean func_call) {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended(func_call);
        }
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onRegisterValueChanged();
        }
    }

    void onMemoryChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryChanged();
        }
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryMapChanged();
        }
    }

    private TCFNodeExpression findScript(String text) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!text.equals(e.getScript())) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (this.expression != null) {
            TCFNodeExpression expression_node = this.findScript(this.expression);
            if (expression_node == null) {
                expression_node = new TCFNodeExpression(this.node, this.expression, null, null, null, null, -1, false);
                this.add(expression_node);
            }
            data.put(expression_node.id, expression_node);
        }
        this.set(null, null, data);
        return true;
    }
}

