/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.GroupMenu;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;

public class NullLocationURIForGroupInPopupMenuConstraint
extends AbstractConstraint {
    private static final String INTERPRETER_SEPARATOR = ":";

    public IStatus validate(IValidationContext ctx) {
        GroupMenu groupMenu;
        IStatus status = null;
        EObject target = ctx.getTarget();
        if (target instanceof GroupMenu && (groupMenu = (GroupMenu)target).eContainer() instanceof PopupMenu && groupMenu.getLocationURI() != null && !groupMenu.getLocationURI().isEmpty()) {
            status = ctx.createFailureStatus(new Object[]{groupMenu.getLocationURI()});
        }
        if (status == null) {
            status = ctx.createSuccessStatus();
        }
        return status;
    }

    public IStatus validate2(IValidationContext ctx) {
        IStatus status = ctx.createSuccessStatus();
        if (ctx.getEventType() == EMFEventType.NULL) {
            EObject eObj = ctx.getTarget();
            String path = "";
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ResourceSet rs = eObj.eResource().getResourceSet();
            EList attrs = eObj.eClass().getEAllAttributes();
            for (EAttribute attr : attrs) {
                if (attr.getEAttributeType() == DescriptionPackage.eINSTANCE.getImagePath()) {
                    path = (String)eObj.eGet((EStructuralFeature)attr);
                    statuses.add(this.validateImagePath(ctx, rs, path));
                    continue;
                }
                if (!(eObj instanceof DecorationDescription) || !attr.equals(DescriptionPackage.eINSTANCE.getDecorationDescription_ImageExpression()) || (path = (String)eObj.eGet((EStructuralFeature)attr)) != null && path.contains(INTERPRETER_SEPARATOR)) continue;
                statuses.add(this.validateImagePath(ctx, rs, path));
            }
            if (statuses.size() > 0) {
                status = ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return status;
    }

    private IStatus validateImagePath(IValidationContext ctx, ResourceSet rs, String path) {
        ArrayList<IStatus> failures = new ArrayList<IStatus>();
        if (!StringUtil.isEmpty((String)path)) {
            if (!this.validateExtension(path)) {
                failures.add(ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.ValidImageConstraint_invalidPathErrorMsg, path)}));
            }
            if (!this.validateExistence(path, rs)) {
                failures.add(ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.ValidImageConstraint_imageDoesntExistErrorMsg, path)}));
            }
        }
        if (failures.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, failures);
    }

    private boolean validateExistence(String path, ResourceSet rs) {
        URIConverter uriConverter = rs.getURIConverter();
        URI workspaceURI = URI.createPlatformResourceURI((String)path, (boolean)true);
        URI pluginsURI = URI.createPlatformPluginURI((String)path, (boolean)true);
        return uriConverter.exists(workspaceURI, null) || uriConverter.exists(pluginsURI, null);
    }

    private boolean validateExtension(String path) {
        boolean isValid = false;
        String extension = new Path(path).getFileExtension();
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().equalsIgnoreCase(extension)) {
                isValid = true;
                break;
            }
            ++n2;
        }
        return isValid;
    }
}

