/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.internal.interpreter.DefaultConverter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.internal.interpreter.EvaluationErrorHandler;

public class SessionInterpreter
implements IInterpreter,
IProposalProvider {
    private final Map<IInterpreterProvider, IInterpreter> loadedInterpreters = new HashMap<IInterpreterProvider, IInterpreter>();
    private Collection<String> dependencies = new LinkedHashSet<String>();
    private Collection<MetamodelDescriptor> additionalMetamodels = new LinkedHashSet<MetamodelDescriptor>();
    private final VariableManager variables = new VariableManager();
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private ModelAccessor modelAccessor;
    private ECrossReferenceAdapter crossReferencer;
    private final Map<String, ProfilerTask> profilerTasks = new HashMap<String, ProfilerTask>();
    private AtomicReference<EvaluationErrorHandler> evaluationErrorHandler = new AtomicReference<EvaluationErrorHandler>(EvaluationErrorHandler.IGNORE);

    public IConverter getConverter() {
        return new DefaultConverter();
    }

    public void withErrorHandler(EvaluationErrorHandler handler, Runnable body) {
        EvaluationErrorHandler old = this.evaluationErrorHandler.getAndSet(handler);
        try {
            body.run();
        }
        finally {
            this.evaluationErrorHandler.compareAndSet(handler, old);
        }
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        this.additionalMetamodels.addAll(metamodels);
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            if (interpreter == null) continue;
            interpreter.activateMetamodels(metamodels);
        }
    }

    public void addImport(String dependency) {
        if (this.dependencies.add(dependency)) {
            for (IInterpreter interpreter : this.loadedInterpreters.values()) {
                if (interpreter == null) continue;
                this.safeAddImport(interpreter, dependency);
            }
        }
    }

    private void safeAddImport(IInterpreter interpreter, String dependency) {
        boolean isSpecialImport = dependency != null && (dependency.startsWith("org.eclipse.sirius.properties.") || dependency.startsWith("org.eclipse.sirius.common."));
        boolean isTargetLegacyInterpreter = interpreter.getClass().getName().startsWith("org.eclipse.sirius.query.legacy.");
        if (!isSpecialImport || !isTargetLegacyInterpreter) {
            interpreter.addImport(dependency);
        }
    }

    public void clearImports() {
        this.dependencies.clear();
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.clearImports();
        }
    }

    public boolean supportsValidation() {
        return true;
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return this.getInterpreter(expression).validateExpression(context, expression);
    }

    public IEvaluationResult evaluateExpression(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreter(expression);
        IEvaluationResult result = null;
        try {
            result = interpreter.evaluateExpression(target, expression);
        }
        catch (EvaluationException evx) {
            this.evaluationErrorHandler.get().handleException((Exception)((Object)evx));
            result = EvaluationResult.ofError((Throwable)evx);
        }
        catch (RuntimeException rex) {
            this.evaluationErrorHandler.get().handleException(rex);
            result = EvaluationResult.ofError((Throwable)rex);
        }
        return result;
    }

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        try {
            this.preEvaluation(expression);
            Object evaluate = this.getInterpreter(expression).evaluate(target, expression);
            this.postEvaluation(expression);
            return evaluate;
        }
        catch (EvaluationException evx) {
            this.evaluationErrorHandler.get().handleException((Exception)((Object)evx));
            throw evx;
        }
        catch (RuntimeException rex) {
            this.evaluationErrorHandler.get().handleException(rex);
            throw rex;
        }
    }

    public boolean provides(String expression) {
        return this.getInterpreter(expression) != null;
    }

    private IInterpreter getInterpreter(String expression) {
        IInterpreterProvider provider = CompoundInterpreter.INSTANCE.getProviderForExpression(expression);
        IInterpreter result = this.loadedInterpreters.get(provider);
        if (result == null) {
            result = provider.createInterpreter();
            this.loadedInterpreters.put(provider, result);
            for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
                result.setProperty(property.getKey(), property.getValue());
                result.clearImports();
            }
            for (String dependency : this.dependencies) {
                this.safeAddImport(result, dependency);
            }
            result.activateMetamodels(this.additionalMetamodels);
            this.variables.setVariables(result);
            result.setModelAccessor(this.modelAccessor);
        }
        result.setCrossReferencer(this.crossReferencer);
        return result;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.setProperty(key, value);
        }
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void clearVariables() {
        this.variables.clearVariables();
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            if (interpreter == null) continue;
            interpreter.clearVariables();
        }
    }

    public void dispose() {
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.dispose();
        }
    }

    public Object getVariable(String name) {
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            if (interpreter.getVariable(name) == null) continue;
            return interpreter.getVariable(name);
        }
        return null;
    }

    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.setVariable(name, value);
        }
    }

    public void unSetVariable(String name) {
        this.variables.unSetVariable(name);
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.unSetVariable(name);
        }
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            for (Map.Entry entry : interpreter.getVariables().entrySet()) {
                result.put((String)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.modelAccessor = modelAccessor;
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.setModelAccessor(modelAccessor);
        }
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        return CompoundInterpreter.INSTANCE.getProposals(interpreter, context);
    }

    public String getPrefix() {
        return CompoundInterpreter.INSTANCE.getPrefix();
    }

    public ContentProposal getNewEmtpyExpression() {
        return CompoundInterpreter.INSTANCE.getNewEmtpyExpression();
    }

    public String getVariablePrefix() {
        return CompoundInterpreter.INSTANCE.getVariablePrefix();
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        this.crossReferencer = crossReferencer;
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            interpreter.setCrossReferencer(crossReferencer);
        }
    }

    private void preEvaluation(String toEval) {
        if (toEval != null && DslCommonPlugin.PROFILER.isActive()) {
            ProfilerTask profilerTask = this.buildInterpretationTask(toEval);
            DslCommonPlugin.PROFILER.startWork(profilerTask);
        }
    }

    private void postEvaluation(String toEval) {
        if (toEval != null && DslCommonPlugin.PROFILER.isActive()) {
            ProfilerTask profilerTask = this.buildInterpretationTask(toEval);
            DslCommonPlugin.PROFILER.stopWork(profilerTask);
        }
    }

    private ProfilerTask buildInterpretationTask(String evaluation) {
        ProfilerTask result = this.profilerTasks.get(evaluation);
        if (result == null) {
            result = new ProfilerTask("Acceleo", evaluation);
            this.profilerTasks.put(evaluation, result);
        }
        return result;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        return CompoundInterpreter.INSTANCE.getProposals(interpreter, context);
    }

    public Collection<String> getImports() {
        return Collections.unmodifiableCollection(this.dependencies);
    }

    public void removeImport(String dependency) {
        this.dependencies.remove(dependency);
        for (IInterpreter interpreter : this.loadedInterpreters.values()) {
            if (interpreter == null) continue;
            interpreter.removeImport(dependency);
        }
    }
}

