/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;

public class ReloadingPolicyImpl
implements ReloadingPolicy {
    private final UICallBack callBack;

    public ReloadingPolicyImpl(UICallBack callBack) {
        this.callBack = Objects.requireNonNull(callBack);
    }

    @Override
    public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        List<Object> result;
        switch (newStatus) {
            case EXTERNAL_CHANGED: {
                result = Collections.singletonList(ReloadingPolicy.Action.RELOAD);
                break;
            }
            case DELETED: {
                result = new ArrayList();
                if (session.getAllSessionResources().contains(resource)) {
                    if (!this.callBack.shouldClose(session, resource)) break;
                    result.add((Object)ReloadingPolicy.Action.CLOSE_SESSION);
                    break;
                }
                result.add((Object)ReloadingPolicy.Action.REMOVE);
                break;
            }
            case CONFLICTING_CHANGED: {
                if (this.callBack.shouldReload(resource)) {
                    result = Collections.singletonList(ReloadingPolicy.Action.RELOAD);
                    break;
                }
                result = Collections.emptyList();
                break;
            }
            case CONFLICTING_DELETED: {
                if (this.callBack.shouldRemove(resource)) {
                    result = Collections.singletonList(ReloadingPolicy.Action.REMOVE);
                    break;
                }
                result = Collections.emptyList();
                break;
            }
            case CHANGES_CANCELED: {
                result = Collections.singletonList(ReloadingPolicy.Action.RELOAD);
                break;
            }
            default: {
                result = Collections.emptyList();
            }
        }
        return result;
    }
}

