/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DTableEraseItemListener
implements Listener {
    private static final boolean IS_WINDOWS_OS = "win32".equals(SWT.getPlatform());
    private static final Color COLOR_LIST_SELECTED = PlatformUI.getWorkbench().getDisplay().getSystemColor(26);
    private static final Color COLOR_LIST_OTHER_CELLS_SELECTED = PlatformUI.getWorkbench().getDisplay().getSystemColor(18);
    private TreeViewer treeViewer;
    private DTableViewerManager tableViewerManager;
    private Widget lastSelectedLineDrawned;
    private int lastSelectedColumnDrawned = -1;

    public DTableEraseItemListener(DTableViewerManager tableViewerManager, TreeViewer treeViewer) {
        this.tableViewerManager = tableViewerManager;
        this.treeViewer = treeViewer;
    }

    public void handleEvent(Event event) {
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        int clientWidth = this.treeViewer.getTree().getClientArea().width;
        GC gc = event.gc;
        Color oldBackground = gc.getBackground();
        if (IS_WINDOWS_OS) {
            if (event.index == this.tableViewerManager.getActiveColumn()) {
                if (this.lastSelectedLineDrawned != null && this.lastSelectedColumnDrawned != -1 && !this.lastSelectedLineDrawned.equals(event.item) && this.lastSelectedColumnDrawned == this.tableViewerManager.getActiveColumn()) {
                    gc.setBackground(COLOR_LIST_OTHER_CELLS_SELECTED);
                } else {
                    gc.setBackground(COLOR_LIST_SELECTED);
                }
                this.lastSelectedLineDrawned = event.item;
                this.lastSelectedColumnDrawned = this.tableViewerManager.getActiveColumn();
            } else {
                gc.setBackground(COLOR_LIST_OTHER_CELLS_SELECTED);
            }
            gc.fillRectangle(event.x, event.y, event.width, event.height);
        } else if (this.tableViewerManager.getActiveColumn() == 0) {
            gc.setBackground(COLOR_LIST_SELECTED);
            gc.fillRectangle(0, event.y, clientWidth, event.height);
        } else if (event.index == this.tableViewerManager.getActiveColumn()) {
            gc.setBackground(COLOR_LIST_SELECTED);
            gc.fillRectangle(event.x, event.y, event.width, event.height);
        } else {
            gc.setBackground(COLOR_LIST_OTHER_CELLS_SELECTED);
            gc.fillRectangle(event.x, event.y, event.width, event.height);
        }
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFFD;
    }
}

