/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;

public class BlankCandidatesExpressionWithRecursiveMappingConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL) {
            Object[] result = null;
            if (eObj instanceof ContainerMapping) {
                result = this.checkError((ContainerMapping)eObj);
            }
            if (result != null) {
                return ctx.createFailureStatus(result);
            }
        }
        return ctx.createSuccessStatus();
    }

    private Object[] checkError(ContainerMapping containerMapping) {
        Object[] result = null;
        if (StringUtil.isEmpty((String)containerMapping.getSemanticCandidatesExpression())) {
            result = containerMapping instanceof ContainerMappingImport ? this.checkNoReusedOfItself((ContainerMappingImport)containerMapping) : this.checkNoReusedOfItself(containerMapping);
        }
        return result;
    }

    private Object[] checkNoReusedOfItself(ContainerMapping containerMappingToCheck) {
        EList<ContainerMapping> allReused;
        if (containerMappingToCheck.isCreateElements() && (allReused = this.getReusedContainerMapping(containerMappingToCheck, true)).contains((Object)containerMappingToCheck)) {
            return new Object[]{containerMappingToCheck, allReused};
        }
        return null;
    }

    private Object[] checkNoReusedOfItself(ContainerMappingImport containerMappingToCheck) {
        ContainerMapping containerMappingImported;
        EList<ContainerMapping> allReused;
        if (containerMappingToCheck.isCreateElements() && ((allReused = this.getReusedContainerMapping(containerMappingImported = containerMappingToCheck.getImportedMapping(), true)).contains((Object)containerMappingImported) || allReused.contains((Object)containerMappingToCheck))) {
            return new Object[]{containerMappingToCheck, allReused};
        }
        return null;
    }

    private EList<ContainerMapping> getReusedContainerMapping(ContainerMapping containerMapping, boolean recurse) {
        EList<ContainerMapping> directReused = containerMapping.getReusedContainerMappings();
        if (containerMapping instanceof ContainerMappingImport && ((ContainerMappingImport)containerMapping).getImportedMapping() != null) {
            directReused.addAll(((ContainerMappingImport)containerMapping).getImportedMapping().getReusedContainerMappings());
        }
        BasicEList result = new BasicEList(directReused);
        if (recurse) {
            for (ContainerMapping reusedContainerMapping : directReused) {
                result.addAll(this.getReusedContainerMapping(reusedContainerMapping, (EList<ContainerMapping>)result));
            }
        }
        return result;
    }

    private EList<ContainerMapping> getReusedContainerMapping(ContainerMapping containerMapping, EList<ContainerMapping> alreadyReused) {
        EList<ContainerMapping> directReused = containerMapping.getReusedContainerMappings();
        if (containerMapping instanceof ContainerMappingImport && ((ContainerMappingImport)containerMapping).getImportedMapping() != null) {
            directReused.addAll(((ContainerMappingImport)containerMapping).getImportedMapping().getReusedContainerMappings());
        }
        BasicEList newReusedContainerMapping = new BasicEList();
        for (ContainerMapping reusedContainerMapping : directReused) {
            if (alreadyReused.contains((Object)reusedContainerMapping) || newReusedContainerMapping.contains((Object)reusedContainerMapping)) continue;
            newReusedContainerMapping.add((Object)reusedContainerMapping);
        }
        BasicEList result = new BasicEList((Collection)newReusedContainerMapping);
        alreadyReused.addAll((Collection)result);
        for (ContainerMapping reusedContainerMapping : newReusedContainerMapping) {
            EList<ContainerMapping> subReusedContainerMapping = this.getReusedContainerMapping(reusedContainerMapping, alreadyReused);
            result.addAll(subReusedContainerMapping);
            alreadyReused.addAll(subReusedContainerMapping);
        }
        return result;
    }
}

