/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.management;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.internal.management.ToolFilterDescriptionListenerForUpdate;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;

public class ToolFilterDescriptionListenersManager {
    private TransactionalEditingDomain domain;
    private Collection<ToolFilterDescriptionListenerForUpdate> listeners;
    private DDiagram dDiagram;

    public void init(DDiagram theDDiagram) {
        this.dDiagram = theDDiagram;
        this.removeListeners();
        this.domain = TransactionUtil.getEditingDomain((EObject)this.dDiagram);
        this.listeners = new LinkedHashSet<ToolFilterDescriptionListenerForUpdate>();
    }

    public void addListenersForFilters(IInterpreter interpreter, Collection<ToolFilterDescription> filters) {
        if (this.listeners != null && this.domain != null) {
            for (ToolFilterDescription filter : filters) {
                ToolFilterDescriptionListenerForUpdate listener = this.getToolFilterDescriptionListener(interpreter, filter);
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                this.listeners.add(listener);
            }
        }
    }

    protected ToolFilterDescriptionListenerForUpdate getToolFilterDescriptionListener(IInterpreter interpreter, ToolFilterDescription filter) {
        return new ToolFilterDescriptionListenerForUpdate(interpreter, filter, this.dDiagram);
    }

    public void dispose() {
        this.removeListeners();
        this.domain = null;
    }

    private void removeListeners() {
        if (this.listeners != null & this.domain != null) {
            for (ToolFilterDescriptionListenerForUpdate listener : this.listeners) {
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
            this.listeners = null;
        }
    }
}

