/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;

public final class ContainerMappingHelper {
    private ContainerMappingHelper() {
    }

    public static Collection<NodeMapping> getAllNodeMappings(ContainerMapping self) {
        LinkedHashSet result = Stream.concat(self.getSubNodeMappings().stream(), self.getReusedNodeMappings().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static Collection<ContainerMapping> getAllContainerMappings(ContainerMapping self) {
        LinkedHashSet result = Stream.concat(self.getSubContainerMappings().stream(), self.getReusedContainerMappings().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static EList<DiagramElementMapping> getAllMappings(ContainerMapping self) {
        BasicEList allMappings = new BasicEList();
        allMappings.addAll(MappingHelper.getAllContainerMappings(self));
        allMappings.addAll(MappingHelper.getAllNodeMappings(self));
        allMappings.addAll(MappingHelper.getAllBorderedNodeMappings(self));
        return new BasicEList.UnmodifiableEList(allMappings.size(), allMappings.toArray());
    }
}

