/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.propertypages;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemPreferenceChangeEvent;
import org.eclipse.rse.internal.core.model.SystemPreferenceChangeEvent;
import org.eclipse.rse.internal.ui.PreferencesMapper;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBooleanFieldEditor;
import org.eclipse.rse.ui.propertypages.SystemTypeFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class RemoteSystemsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private SystemBooleanFieldEditor showFilterPoolsEditor;
    private SystemBooleanFieldEditor qualifyConnectionNamesEditor;
    private SystemBooleanFieldEditor rememberStateEditor;
    private SystemBooleanFieldEditor restoreFromCache;
    private Composite innerComposite;
    private SystemTypeFieldEditor systemTypesEditor;
    private SystemBooleanFieldEditor showNewConnectionPromptEditor;
    private boolean lastShowFilterPoolsValue = false;
    private boolean lastQualifyConnectionNamesValue = false;
    private boolean lastRememberStateValue = true;
    private boolean lastShowNewConnectionPromptValue = true;
    private boolean lastUseDeferredQueryValue = false;

    public RemoteSystemsPreferencePage() {
        super(1);
        this.setTitle(SystemResources.RESID_PREF_ROOT_PAGE);
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.rsep0000");
    }

    protected void createFieldEditors() {
        PreferencesMapper coreStore = new PreferencesMapper(RSECorePlugin.getDefault().getPluginPreferences());
        this.systemTypesEditor = new SystemTypeFieldEditor("org.eclipse.rse.preferences.systemtype.info", SystemResources.RESID_PREF_USERID_PERTYPE_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField(this.systemTypesEditor);
        this.systemTypesEditor.setToolTipText(SystemResources.RESID_PREF_USERID_PERTYPE_PREFIX_TOOLTIP);
        this.qualifyConnectionNamesEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.qualifyconnectionnames", SystemResources.RESID_PREF_QUALIFYCONNECTIONNAMES_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.qualifyConnectionNamesEditor);
        this.qualifyConnectionNamesEditor.setToolTipText(SystemResources.RESID_PREF_QUALIFYCONNECTIONNAMES_PREFIX_TOOLTIP);
        this.lastQualifyConnectionNamesValue = this.getPreferenceStore().getBoolean(this.qualifyConnectionNamesEditor.getPreferenceName());
        this.showFilterPoolsEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.filterpools.show", SystemResources.RESID_PREF_SHOWFILTERPOOLS_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showFilterPoolsEditor);
        this.showFilterPoolsEditor.setToolTipText(SystemResources.RESID_PREF_SHOWFILTERPOOLS_PREFIX_TOOLTIP);
        this.lastShowFilterPoolsValue = this.getPreferenceStore().getBoolean(this.showFilterPoolsEditor.getPreferenceName());
        this.showNewConnectionPromptEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.shownewconnection", SystemResources.RESID_PREF_SHOWNEWCONNECTIONPROMPT_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showNewConnectionPromptEditor);
        this.showNewConnectionPromptEditor.setToolTipText(SystemResources.RESID_PREF_SHOWNEWCONNECTIONPROMPT_PREFIX_TOOLTIP);
        this.lastShowNewConnectionPromptValue = this.getPreferenceStore().getBoolean(this.showNewConnectionPromptEditor.getPreferenceName());
        this.rememberStateEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.rememberState", SystemResources.RESID_PREF_REMEMBERSTATE_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.rememberStateEditor);
        this.rememberStateEditor.setToolTipText(SystemResources.RESID_PREF_REMEMBERSTATE_PREFIX_TOOLTIP);
        this.lastRememberStateValue = this.getPreferenceStore().getBoolean(this.rememberStateEditor.getPreferenceName());
        this.innerComposite = SystemWidgetHelpers.createComposite(this.getFieldEditorParent(), 0);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 20;
        this.innerComposite.setLayoutData((Object)gd);
        this.restoreFromCache = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.restoreStateFromCache", SystemResources.RESID_PREF_RESTOREFROMCACHE_PREFIX_LABEL, this.innerComposite);
        this.restoreFromCache.setEnabled(this.lastRememberStateValue, this.innerComposite);
        this.addField((FieldEditor)this.restoreFromCache);
        this.restoreFromCache.setToolTipText(SystemResources.RESID_PREF_RESTOREFROMCACHE_PREFIX_TOOLTIP);
        new Mnemonics().setOnPreferencePage(true).setMnemonics(this.getFieldEditorParent());
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object newValue;
        if (event.getSource() == this.rememberStateEditor && (newValue = event.getNewValue()) instanceof Boolean) {
            this.restoreFromCache.setEnabled((Boolean)newValue, this.innerComposite);
        }
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean newValue;
        boolean ok = super.performOk();
        SystemPreferencesManager.savePreferences();
        if (!RSECorePlugin.isTheSystemRegistryActive()) {
            return ok;
        }
        if (this.showFilterPoolsEditor != null) {
            newValue = this.showFilterPoolsEditor.getBooleanValue();
            if (newValue != this.lastShowFilterPoolsValue) {
                RSEUIPlugin.getTheSystemRegistryUI().setShowFilterPools(newValue);
                this.firePreferenceChangeEvent(5, this.lastShowFilterPoolsValue, newValue);
            }
            this.lastShowFilterPoolsValue = newValue;
        }
        if (this.showNewConnectionPromptEditor != null) {
            newValue = this.showNewConnectionPromptEditor.getBooleanValue();
            if (newValue != this.lastShowNewConnectionPromptValue) {
                RSEUIPlugin.getTheSystemRegistryUI().setShowNewHostPrompt(newValue);
            }
            this.lastShowNewConnectionPromptValue = newValue;
        }
        if (this.qualifyConnectionNamesEditor != null) {
            newValue = this.qualifyConnectionNamesEditor.getBooleanValue();
            if (newValue != this.lastQualifyConnectionNamesValue) {
                RSEUIPlugin.getTheSystemRegistryUI().setQualifiedHostNames(newValue);
                this.firePreferenceChangeEvent(15, this.lastQualifyConnectionNamesValue, newValue);
            }
            this.lastQualifyConnectionNamesValue = newValue;
        }
        if (this.rememberStateEditor != null) {
            newValue = this.rememberStateEditor.getBooleanValue();
            if (newValue != this.lastRememberStateValue) {
                this.firePreferenceChangeEvent(20, this.lastRememberStateValue, newValue);
            }
            this.lastRememberStateValue = newValue;
        }
        return ok;
    }

    private void firePreferenceChangeEvent(int type, boolean oldValue, boolean newValue) {
        RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemPreferenceChangeEvent)new SystemPreferenceChangeEvent(type, (Object)(oldValue ? Boolean.TRUE : Boolean.FALSE), (Object)(newValue ? Boolean.TRUE : Boolean.FALSE)));
    }
}

