/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.direct.project;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.reddeer.common.exception.RedDeerException;

public class Project {
    public static void delete(String projectName, boolean deleteContent, boolean force) {
        try {
            Project.getProject(projectName).delete(deleteContent, force, null);
        }
        catch (CoreException ce) {
            throw new RuntimeException("Unable to delete project " + projectName, ce);
        }
    }

    public static List<String> getProjectNatureIds(String projectName) {
        List<String> natureIds = null;
        try {
            natureIds = Arrays.asList(Project.getProject(projectName).getDescription().getNatureIds());
        }
        catch (CoreException coreException) {
            throw new RuntimeException("Cannot get natures of project " + projectName + ". Project is not opened.");
        }
        return natureIds;
    }

    public static boolean isProject(String projectName) {
        return Project.getProject(projectName).exists();
    }

    public static boolean isOpen(String projectName) {
        return Project.getProject(projectName).isOpen();
    }

    private static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static String getLocation(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
    }

    public static void create(String projectName) {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        try {
            project.create((IProgressMonitor)progressMonitor);
            project.open((IProgressMonitor)progressMonitor);
        }
        catch (CoreException e) {
            throw new RedDeerException("Cannot create a project '" + projectName + "'", (Throwable)e);
        }
    }
}

