/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeHandler
extends ControlHandler {
    private static final Logger logger = Logger.getLogger(TreeHandler.class);
    private static TreeHandler instance;

    public static TreeHandler getInstance() {
        if (instance == null) {
            instance = new TreeHandler();
        }
        return instance;
    }

    public List<TreeItem> getSWTItems(final Tree swtTree) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<TreeItem>>(){

            public List<TreeItem> run() {
                return Arrays.asList(swtTree.getItems());
            }
        });
    }

    public int getColumnCount(final Tree swtTree) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return swtTree.getColumnCount();
            }
        });
    }

    public List<String> getHeaderColumns(final Tree swtTree) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<String>>(){

            public List<String> run() {
                TreeColumn[] columns;
                ArrayList<String> columnTexts = new ArrayList<String>();
                TreeColumn[] treeColumnArray = columns = swtTree.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    columnTexts.add(column.getText());
                    ++n2;
                }
                return columnTexts;
            }
        });
    }

    public void unselectAllItems(final Tree swtTree) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.debug("Unselect all tree items");
                swtTree.deselectAll();
            }
        });
        this.notifySelect(swtTree);
        logger.info("All tree items unselected");
    }

    public TreeItem[] getSelection(final Tree swtTree) {
        return (TreeItem[])Display.syncExec((ResultRunnable)new ResultRunnable<TreeItem[]>(){

            public TreeItem[] run() {
                return swtTree.getSelection();
            }
        });
    }

    public void notifySelect(final Tree swtTree) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.debug("Notify Tree about selection event");
                swtTree.notifyListeners(13, TreeHandler.this.createSelectionEvent(swtTree));
            }
        });
    }

    private Event createSelectionEvent(Tree swtTree) {
        Event event = new Event();
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.widget = swtTree;
        event.type = 13;
        return event;
    }

    public Event createEventForTree(TreeItem swtTreeItem, int type) {
        return this.createEventForTree(swtTreeItem, type, 0);
    }

    public Event createEventForTree(TreeItem swtTreeItem, int type, int detail) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = swtTreeItem;
        event.widget = TreeItemHandler.getInstance().getParent(swtTreeItem);
        event.detail = detail;
        return event;
    }

    public void notifyTree(final TreeItem swtTreeItem, final Event event) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.getParent().notifyListeners(event.type, event);
            }
        });
    }

    public void notifyTree(final TreeItem swtTreeItem, final int eventType, final Event event) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.getParent().notifyListeners(eventType, event);
            }
        });
    }

    public void notifyTreeSync(final TreeItem swtTreeItem, final Event event) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.getParent().notifyListeners(event.type, event);
            }
        });
    }
}

