/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public class StyledTextHandler
extends ControlHandler {
    private static StyledTextHandler instance;

    public static StyledTextHandler getInstance() {
        if (instance == null) {
            instance = new StyledTextHandler();
        }
        return instance;
    }

    public void setSelectionWithinLine(final StyledText styledText, final int line, final int column) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int offset = styledText.getContent().getOffsetAtLine(line) + column;
                styledText.setSelection(offset);
            }
        });
    }

    public void setSelection(final StyledText styledText, final int start, final int end) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                styledText.setSelection(start, end);
            }
        });
    }

    public void insertText(final StyledText styledText, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                styledText.insert(text);
            }
        });
    }

    public void insertText(StyledText styledText, int line, int column, String text) {
        this.setSelectionWithinLine(styledText, line, column);
        this.insertText(styledText, text);
    }

    public int getPositionOfText(final StyledText styledText, final String text) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return styledText.getText().indexOf(text);
            }
        });
    }

    public void selectText(final StyledText styledText, final String text) {
        final int position = this.getPositionOfText(styledText, text);
        if (position == -1) {
            throw new CoreLayerException("Unable to find text " + text + " in styled text");
        }
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                styledText.setSelection(position, position + text.length());
            }
        });
    }

    public void selectPosition(final StyledText styledText, final int position) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                styledText.setSelection(position);
            }
        });
    }

    public String getSelectionText(final StyledText styledText) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return styledText.getSelectionText();
            }
        });
    }

    public Point getCursorPosition(final StyledText styledText) {
        return (Point)Display.syncExec((ResultRunnable)new ResultRunnable<Point>(){

            public Point run() {
                styledText.setFocus();
                int offset = styledText.getSelectionRange().x;
                int line = styledText.getContent().getLineAtOffset(offset);
                int offsetAtLine = styledText.getContent().getOffsetAtLine(line);
                int column = offset - offsetAtLine;
                return new Point(line, column);
            }
        });
    }

    public int getLineOffset(final StyledText styledText, final int line) {
        int offset = (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                styledText.setFocus();
                int offsetAtLine = styledText.getOffsetAtLine(line);
                return offsetAtLine;
            }
        });
        return offset;
    }

    public String getText(final StyledText styledText) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return styledText.getText();
            }
        });
    }

    public void setText(final StyledText styledText, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                styledText.setText(text);
            }
        });
    }
}

