/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.platform.RunningPlatform;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ButtonHandler
extends ControlHandler {
    private static ButtonHandler instance;

    public static ButtonHandler getInstance() {
        if (instance == null) {
            instance = new ButtonHandler();
        }
        return instance;
    }

    public void click(final Button button) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((button.getStyle() & 2) != 0 || (button.getStyle() & 0x20) != 0) {
                    button.setSelection(!button.getSelection());
                }
            }
        });
        this.sendClickNotifications((Widget)button);
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!button.isDisposed()) {
                    this.handleNotSelectedRadioButton(button);
                }
            }

            private void handleNotSelectedRadioButton(Button button2) {
                if ((button2.getStyle() & 0x10) == 0 || button2.getSelection()) {
                    return;
                }
                this.deselectSelectedSiblingRadio(button2);
                this.selectRadio(button2);
            }

            private void deselectSelectedSiblingRadio(Button button2) {
                Control[] siblings;
                if ((button2.getParent().getStyle() & 0x400000) != 0) {
                    return;
                }
                Control[] controlArray = siblings = button2.getParent().getChildren();
                int n = siblings.length;
                int n2 = 0;
                while (n2 < n) {
                    Button sibling;
                    Control widget = controlArray[n2];
                    if (widget instanceof Button && ((sibling = (Button)widget).getStyle() & 0x10) != 0 && sibling.getSelection()) {
                        ButtonHandler.this.notifyWidget(27, (Widget)sibling);
                        sibling.setSelection(false);
                        ButtonHandler.this.notifyWidget(13, (Widget)sibling);
                    }
                    ++n2;
                }
            }

            private void selectRadio(Button button2) {
                ButtonHandler.this.notifyWidget(26, (Widget)button2);
                ButtonHandler.this.notifyWidget(3, (Widget)button2);
                ButtonHandler.this.notifyWidget(4, (Widget)button2);
                button2.setSelection(true);
                ButtonHandler.this.notifyWidget(13, (Widget)button2);
            }
        });
    }

    public boolean isSelected(final Button button) {
        boolean selectionState = (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return button.getSelection();
            }
        });
        return selectionState;
    }

    public String getText(final Button button) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return button.getText();
            }
        });
    }

    public void setFocus(final Button button) {
        if (!RunningPlatform.isWindows() || (this.getStyle((Widget)button) & 0x10) == 0) {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    button.setFocus();
                }
            });
        }
    }
}

