/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.condition;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.util.InstanceValidator;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class ShellMatchingMatcherIsAvailable
extends AbstractWaitCondition {
    private AndMatcher matcher;
    protected Shell foundShell;

    public ShellMatchingMatcherIsAvailable(Matcher<?> ... matchers) {
        AndMatcher am;
        InstanceValidator.checkNotNull(matchers, "matcher");
        this.matcher = am = new AndMatcher(matchers);
    }

    public boolean test() {
        Shell[] availableShells;
        Shell[] shellArray = availableShells = ShellLookup.getInstance().getShells();
        int n = availableShells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (this.matcher.matches((Object)shell)) {
                this.foundShell = shell;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Shell getResult() {
        return this.foundShell;
    }

    public String description() {
        return "shell matching " + this.matcher + " is available.";
    }

    public String errorMessageWhile() {
        return "shell matching " + this.matcher + " is still available.";
    }

    public String errorMessageUntil() {
        return "shell matching " + this.matcher + " not found.";
    }
}

