/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class EclInformationContol
extends BrowserInformationControl {
    private static String styles = null;

    public EclInformationContol(Shell parent, boolean resizeable) {
        super(parent, "org.eclipse.jface.dialogfont", resizeable);
    }

    public static boolean isAvailable(Shell parent) {
        return BrowserInformationControl.isAvailable((Composite)parent);
    }

    public void setInformation(String content) {
        super.setInformation(EclInformationContol.applyStyling(content));
    }

    public static String applyStyling(String html) {
        String styles = EclInformationContol.loadStyles();
        FontData fontData = JFaceResources.getDialogFont().getFontData()[0];
        styles = HTMLPrinter.convertTopLevelFont((String)styles, (FontData)fontData);
        StringBuffer b = new StringBuffer(html);
        b.insert(0, "</style></head><body>");
        b.insert(0, styles);
        b.insert(0, "<html><head><style type=\"text/css\">");
        b.append("</body></html>");
        return b.toString();
    }

    private static String loadStyles() {
        if (styles != null) {
            return styles;
        }
        try {
            URL url = Q7UIPlugin.getDefault().getBundle().getResource("/docs.css");
            if (url == null) {
                styles = "";
                return "";
            }
            styles = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            return styles;
        }
        catch (IOException e) {
            Q7UIPlugin.log(e);
            styles = "";
            return "";
        }
    }
}

