/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.tags.SelectTagDialog;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddTagAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SelectTagDialog dialog;
        IResource[] resources = LaunchUtils.getContext(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        final IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])resources, (boolean)false, (boolean)false);
        ArrayList<String> disabledTags = null;
        if (elements.length == 1) {
            try {
                disabledTags = TagsUtil.extractTags((String)elements[0].getTags());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        if (disabledTags == null) {
            disabledTags = new ArrayList();
        }
        if ((dialog = new SelectTagDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), disabledTags)).open() == 0) {
            Job job = new Job(Messages.AddTagAction_Job){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.AddTagAction_Task, elements.length);
                    try {
                        WriteAccessChecker writeAccessChecker = new WriteAccessChecker(dialog.getShell());
                        if (!writeAccessChecker.makeResourceWritable((IQ7Element[])elements)) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IQ7NamedElement[] iQ7NamedElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IQ7NamedElement element = iQ7NamedElementArray[n2];
                        if (monitor.isCanceled()) break;
                        try {
                            AddTagAction.this.doAddTag(element, dialog.getResult(), dialog.getTagName(), monitor);
                        }
                        catch (ModelException e) {
                            RcpttPlugin.log((Throwable)e);
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    protected void doAddTag(IQ7NamedElement element, List<Tag> selected, String newTag, final IProgressMonitor monitor) throws ModelException {
        block17: {
            String tags = element.getTags();
            NamedElement namedElement = element.getModifiedNamedElement();
            if (namedElement != null) {
                tags = namedElement.getTags();
            }
            List existingTags = TagsUtil.extractTags((String)tags);
            StringBuilder sb = new StringBuilder(tags);
            boolean first = existingTags.isEmpty();
            if (!selected.isEmpty()) {
                for (Tag tag : selected) {
                    if (existingTags.contains(tag.getPath())) continue;
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(tag.getPath());
                }
            } else if (newTag != null) {
                if (existingTags.contains(newTag.trim())) {
                    return;
                }
                if (sb.toString().length() != 0) {
                    sb.append(", ");
                }
                sb.append(newTag.trim());
            }
            if (sb.length() > 0) {
                try {
                    final INamedElementEditor editor = ModelUtils.findEditor(element);
                    if (editor != null) {
                        boolean wasDirty = editor.isDirty();
                        editor.setTags(sb.toString());
                        if (!wasDirty) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    editor.doSave(monitor);
                                }
                            });
                        }
                        break block17;
                    }
                    IQ7NamedElement copy = element.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                    try {
                        copy.setTags(sb.toString());
                        copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        copy.discardWorkingCopy();
                    }
                }
                catch (Throwable e) {
                    Q7UIPlugin.log(e);
                }
            }
        }
    }
}

