/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexRequest;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;

public class NamedElementRemoveRequest
extends IndexRequest {
    private final IQ7Project project;
    private final String path;

    public NamedElementRemoveRequest(IProjectIndexer indexer, IQ7Project project, String path) {
        super(indexer);
        this.project = project;
        this.path = path;
    }

    @Override
    protected String getName() {
        return this.path;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getName());
    }

    @Override
    protected void run() throws CoreException, IOException {
        Index index = this.getIndexer().getProjectIndex(this.project);
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            index.remove(this.path);
        }
        finally {
            imon.exitWrite();
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedElementRemoveRequest other = (NamedElementRemoveRequest)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

